/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.ListShardingKeys;
import oracle.ucp.routing.RangeShardingKeys;
import oracle.ucp.routing.RoutingKey;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.routing.SuperShardingKeys;

@DefaultLogger(value="oracle.ucp.jdbc.routing")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public abstract class RACDataAffinityRoutingCache
extends ShardRoutingCache {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    @Override
    protected RoutingKey makeRoutingKey(Chunk.Metadata chunkInfo) throws SQLException {
        ShardingKeys shardingKeys;
        ShardingMetadata sm = this.shardingMetadata();
        ShardingMetadata.ShardingType sType = this.shardingMetadata().getShardingType();
        SuperShardingKeys superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
        if (sType == ShardingMetadata.ShardingType.LIST) {
            shardingKeys = new ListShardingKeys(OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true));
        } else if (sType == ShardingMetadata.ShardingType.RANGE) {
            shardingKeys = new RangeShardingKeys((OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true).get(0), (OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyLow, (ShardingMetadata)sm, (boolean)false, (boolean)false).get(0));
        } else if (sType == ShardingMetadata.ShardingType.HASH) {
            OracleShardingKeyImpl dummyKey = new OracleShardingKeyBuilderImpl().subkey((Object)chunkInfo.chunkId, (SQLType)OracleType.NUMBER).build();
            shardingKeys = new HashRangeShardingKeys((OracleShardingKey)dummyKey, (OracleShardingKey)dummyKey);
        } else {
            throw new IllegalStateException("Shard Type in database not recognized");
        }
        return new RoutingKey(shardingKeys, superShardingKeys);
    }

    private List<Chunk> chunks(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return Collections.emptyList();
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey key = jdbcCri.getShardingKey();
        if (Objects.isNull(key) || Objects.isNull(this.shardingMetadata())) {
            return Collections.emptyList();
        }
        ShardingMetadata.ShardingType sType = this.shardingMetadata().getShardingType();
        if (sType == ShardingMetadata.ShardingType.LIST || sType == ShardingMetadata.ShardingType.RANGE) {
            return this.chunks(null, key);
        }
        return this.chunks(this.getChunkId(key));
    }

    private int getChunkId(OracleShardingKey shardingKey) {
        long chunkCount = this.chunksCount();
        long hashMask = 1L;
        long bucketSize = chunkCount;
        while ((bucketSize >>= 1) > 0L) {
            hashMask <<= 1;
        }
        hashMask = (hashMask << 1) - 1L;
        long keyHashValue = ((OracleShardingKeyImpl)shardingKey).shardKeyOraHash(this.shardingMetadata());
        long hashBucket = keyHashValue & hashMask;
        if (hashBucket >= chunkCount) {
            hashBucket = keyHashValue & hashMask >> 1;
        }
        return (int)(hashBucket + 1L);
    }

    @Override
    protected boolean hasKeyMapped(OracleShardingKey shardingKey, OracleShardingKey superKey) {
        return true;
    }

    @Override
    public ServiceMember getBestInstanceToGrow(ConnectionRetrievalInfo cri) {
        return this.getAffinitizedInstance(cri);
    }

    @Override
    public Set<ServiceMember> instancesToGrow(ConnectionRetrievalInfo cri) {
        return this.allInstances(cri);
    }

    @Override
    public Set<ServiceMember> allInstances(ConnectionRetrievalInfo cri) {
        HashSet<ServiceMember> affinitizedInstanceSet = new HashSet<ServiceMember>();
        ServiceMember affinitizedInstance = this.getAffinitizedInstance(cri);
        if (affinitizedInstance != null) {
            affinitizedInstanceSet.add(affinitizedInstance);
        }
        return affinitizedInstanceSet;
    }

    @Override
    public Set<ServiceMember> allPriorityInstances(ConnectionRetrievalInfo cri) {
        return this.allInstances(cri);
    }

    private ServiceMember getAffinitizedInstance(ConnectionRetrievalInfo cri) {
        List<Chunk> reqChunks = this.chunks(cri);
        if (reqChunks != null && reqChunks.size() > 0) {
            for (Chunk chunk : reqChunks) {
                Set<ServiceMember> allInstances = chunk.instances();
                for (ServiceMember instance : allInstances) {
                    if (instance.dbInstanceId() != chunk.affinitizedInstId().get()) continue;
                    return instance;
                }
            }
        }
        return null;
    }

    @Override
    protected boolean multipleTableFamilySupported(Connection conn) throws SQLException {
        return false;
    }

    @Override
    public void onHAEvent(FailoverDriver.Event haEvent) {
    }

    @Override
    public void onConnectionBorrow(Connection connection, ConnectionRetrievalInfo cri) throws SQLException {
    }

    @Override
    public void onConnectionReturn(Connection connection) throws SQLException {
    }

    static {
        try {
            $$$methodRef$$$13 = RACDataAffinityRoutingCache.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = RACDataAffinityRoutingCache.class.getDeclaredMethod("onConnectionReturn", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = RACDataAffinityRoutingCache.class.getDeclaredMethod("onConnectionBorrow", Connection.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = RACDataAffinityRoutingCache.class.getDeclaredMethod("onHAEvent", FailoverDriver.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = RACDataAffinityRoutingCache.class.getDeclaredMethod("multipleTableFamilySupported", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = RACDataAffinityRoutingCache.class.getDeclaredMethod("getAffinitizedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = RACDataAffinityRoutingCache.class.getDeclaredMethod("allPriorityInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = RACDataAffinityRoutingCache.class.getDeclaredMethod("allInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = RACDataAffinityRoutingCache.class.getDeclaredMethod("instancesToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = RACDataAffinityRoutingCache.class.getDeclaredMethod("getBestInstanceToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = RACDataAffinityRoutingCache.class.getDeclaredMethod("hasKeyMapped", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = RACDataAffinityRoutingCache.class.getDeclaredMethod("getChunkId", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = RACDataAffinityRoutingCache.class.getDeclaredMethod("chunks", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = RACDataAffinityRoutingCache.class.getDeclaredMethod("makeRoutingKey", Chunk.Metadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

