<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\Exporters_Development\ExportersDevelopmentService;

class ExportersDevelopmentController extends Controller
{   

    public function exportersDevelopmentService()
    {
        return new ExportersDevelopmentService;
    }


    public function index(Request $request)
    {   
        $exporters_development = $this->getRequestData($request, 'exporters_development');
        $date_range = $this->getRequestData($request, 'date_range');

        return view('content.dashboard.exporters-development', compact(
            'exporters_development',
            'date_range',
        ));
    }

    private function getRequestData(Request $request, $field_name)
    {   
        return json_decode(decrypt($request->query($field_name)));
    }

    public function programme(Request $request)
    {   
        $date_range = $this->getRequestData($request, 'date_range');
        $result = $this->exportersDevelopmentService()->getExportersDevelopmentProgrammeData($date_range);
        return view('content.dashboard.programme-btpd', compact(
            'result',
            'date_range'
        ));
    }

    public function exportSales(Request $request)
    {   
        $date_range = $this->getRequestData($request, 'date_range');
        $result = $this->exportersDevelopmentService()->getExportersDevelopmentExportSalesData($date_range);
        return view('content.dashboard.export-sales-btpd', compact(
            'result',
            'date_range'
        ));
    }

    public function companiesAssisted(Request $request)
    {   
        $date_range = $this->getRequestData($request, 'date_range');
        $result = $this->exportersDevelopmentService()->getExportersDevelopmentCompaniesAssistedData($date_range);
        return view('content.dashboard.companies-assisted-btpd', compact(
            'result',
            'date_range'
        ));
    }
}
