<?php

namespace App\Http\Controllers\dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Services\Dashboard\DashboardService;

class Analytics extends Controller
{
  public function index(Request $request, DashboardService $dashboardService)
  {   
    $dashboard = $dashboardService->getDashboardData($request);
    
    $matrade_achievement = $dashboard->matrade_achievement;
    $export_promotions = $dashboard->export_promotions;
    $exporters_development = $dashboard->exporters_development;
    $date_range = $dashboard->date_range;
    
    return view('content.dashboard.dashboards-analytics', compact(
      'matrade_achievement',
      'export_promotions',
      'exporters_development',
      'date_range'
    ));
  }
}
