<?php

$spBaseUrl = 'https://kpitst.matrade.gov.my/sso';

$settings = array (
    // If 'strict' is True, then the PHP Toolkit will reject unsigned
    // or unencrypted messages if it expects them signed or encrypted
    // Also will reject the messages if not strictly follow the SAML
    // standard: Destination, NameId, Conditions ... are validated too.
    'strict' => true,

    // Enable debug mode (to print errors)
    'debug' => false,

    // Set a BaseURL to be used instead of try to guess
    // the BaseURL of the view that process the SAML Message.
    // Ex. http://sp.example.com/
    //     http://example.com/sp/
    'baseurl' => null,

    // Service Provider Data that we are deploying
    'sp' => array (
        // Identifier of the SP entity  (must be a URI)
        'entityId' => $spBaseUrl.'/metadata.php',
        // Specifies info about where and how the <AuthnResponse> message MUST be
        // returned to the requester, in this case our SP.
        'assertionConsumerService' => array (
            // URL Location where the <Response> from the IdP will be returned
            'url' => $spBaseUrl.'/acs.php',
            // SAML protocol binding to be used when returning the <Response>
            // message.  Onelogin Toolkit supports for this endpoint the
            // HTTP-POST binding only
            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
        ),
        // If you need to specify requested attributes, set a
        // attributeConsumingService. nameFormat, attributeValue and
        // friendlyName can be omitted. Otherwise remove this section.
        //"attributeConsumingService"=> array(
        //        "serviceName" => "SP test",
        //        "serviceDescription" => "Test Service",
        //        "requestedAttributes" => array(
        //            array(
        //                "name" => "",
        //                "isRequired" => false,
        //                "nameFormat" => "",
        //                "friendlyName" => "",
        //                "attributeValue" => ""
        //            )
        //        )
        //),
        // Specifies info about where and how the <Logout Response> message MUST be
        // returned to the requester, in this case our SP.
        'singleLogoutService' => array (
            // URL Location where the <Response> from the IdP will be returned
            'url' => $spBaseUrl.'/sls.php',
            // SAML protocol binding to be used when returning the <Response>
            // message.  Onelogin Toolkit supports for this endpoint the
            // HTTP-Redirect binding only
            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
        ),
        // Specifies constraints on the name identifier to be used to
        // represent the requested subject.
        // Take a look on lib/Saml2/Constants.php to see the NameIdFormat supported
        'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',

        // Usually x509cert and privateKey of the SP are provided by files placed at
        // the certs folder. But we can also provide them with the following parameters
        'x509cert' => '',
        'privateKey' => '',

        /*
         * Key rollover
         * If you plan to update the SP x509cert and privateKey
         * you can define here the new x509cert and it will be
         * published on the SP metadata so Identity Providers can
         * read them and get ready for rollover.
         */
        // 'x509certNew' => '',
    ),

    // Identity Provider Data that we want connect with our SP
    'idp' => array (
        // Identifier of the IdP entity  (must be a URI)
        'entityId' => 'http://logon.matrade.gov.my/adfs/services/trust',
        // SSO endpoint info of the IdP. (Authentication Request protocol)
        'singleSignOnService' => array (
            // URL Target of the IdP where the SP will send the Authentication Request Message
            'url' => 'https://logon.matrade.gov.my/adfs/ls/idpinitiatedsignon.htm',
            // SAML protocol binding to be used when returning the <Response>
            // message.  Onelogin Toolkit supports for this endpoint the
            // HTTP-Redirect binding only
            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
        ),
        // SLO endpoint info of the IdP.
        'singleLogoutService' => array (
            // URL Location of the IdP where the SP will send the SLO Request
            'url' => 'https://logon.matrade.gov.my/adfs/ls',
            // URL location of the IdP where the SP will send the SLO Response (ResponseLocation)
            // if not set, url for the SLO Request will be used
            'responseUrl' => 'https://logon.matrade.gov.my/adfs/ls',
            // SAML protocol binding to be used when returning the <Response>
            // message.  Onelogin Toolkit supports for this endpoint the
            // HTTP-Redirect binding only
            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
        ),
        // Public x509 certificate of the IdP
        'x509cert' => '-----BEGIN CERTIFICATE-----
MIIC5DCCAcygAwIBAgIQG8IKOTGQMLFLT+BcbZB2cjANBgkqhkiG9w0BAQsFADAu
MSwwKgYDVQQDEyNBREZTIFNpZ25pbmcgLSBsb2dvbi5tYXRyYWRlLmdvdi5teTAe
Fw0yMDEwMDYwOTMzMTFaFw0yMzEwMDYwOTMzMTFaMC4xLDAqBgNVBAMTI0FERlMg
U2lnbmluZyAtIGxvZ29uLm1hdHJhZGUuZ292Lm15MIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEAuVJvxh3zZ4N+4vDOiTTYIIlBbCsioWLzwCQ5AdItfh63
h0nN/LpJ2+laBlluLSsQG85o2TURH6XC4uZU97TA6Pk2YdhVmobiz8QHjVotHJlF
N/3ncBBu/ZSvA+9mgN4FVBawtGjmJeGvea6izqYh+8w8r7eXRXuqM+55+bpOUGH5
p78t35449M47tZogzFa+WzNmCON69nJ7gDF+9flGaAdldugW+tj3ToV+llUu7xsx
Rei++JDZyFhjX6ei3qLdWbkPtsO4GtcC1jWm4pElCk8VjX+ll5Hhw0X/RHC5JDrI
TBMZM7wTmsF4x5xiL4F2N+ghqTv6cfs7cSbuNG9p4QIDAQABMA0GCSqGSIb3DQEB
CwUAA4IBAQBdD/UB4ILClzWW7pJRWiA0zjwBtN0t88999kUrnY/sLqfC/sx8o7JJ
hEGGqu/5aFPP+SvqXUXCUXgHHT9MGMcTpHdqsddbnpRrXIDAYNY+vxOqUXRe4q8w
YzNaJFe4xxHvpqF/cd+18CMd8Bw4LGvcKnx+4zUHZAc8QP6wepwR689sVsc3aeSe
XYOkRsOXAMno5TmdQMpv2+2euGRKD/imgXHjnRdQLkNvgHdVegnKwxBrslCG82UK
pCmzwaUo130n1J60Xl5cDi7l2DNFCZP2ldIN3k+u7EO5WfGBS//f0rYbG4Ya+BGO
PgjTS+SCcp4zFs3c/Eih6d1De8PjGs0o
-----END CERTIFICATE-----
',
        /*
         *  Instead of use the whole x509cert you can use a fingerprint in
         *  order to validate the SAMLResponse, but we don't recommend to use
         *  that method on production since is exploitable by a collision
         *  attack.
         *  (openssl x509 -noout -fingerprint -in "idp.crt" to generate it,
         *   or add for example the -sha256 , -sha384 or -sha512 parameter)
         *
         *  If a fingerprint is provided, then the certFingerprintAlgorithm is required in order to
         *  let the toolkit know which Algorithm was used. Possible values: sha1, sha256, sha384 or sha512
         *  'sha1' is the default value.
         */
        // 'certFingerprint' => '',
        // 'certFingerprintAlgorithm' => 'sha1',

        /* In some scenarios the IdP uses different certificates for
         * signing/encryption, or is under key rollover phase and more
         * than one certificate is published on IdP metadata.
         * In order to handle that the toolkit offers that parameter.
         * (when used, 'x509cert' and 'certFingerprint' values are
         * ignored).
         */
        // 'x509certMulti' => array(
        //      'signing' => array(
        //          0 => '<cert1-string>',
        //      ),
        //      'encryption' => array(
        //          0 => '<cert2-string>',
        //      )
        // ),
    ),
);
