@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Achievement - Type 5')

@section('content')
<br>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<div class="container my-4">
  <div class="card">
    <div class="card-header">
      <h4 class="mb-0">Achievement Details (Type 5)</h4>
    </div>

    <div class="card-body">
      <table class="table table-bordered">
        <tbody>
          <tr><th class="w-50 fw-bold">Year :</th><td>2025</td></tr>
          <tr><th class="fw-bold">Quarter :</th><td>2</td></tr>
          <tr><th class="fw-bold">Division :</th><td>EXPORTS PROMOTION & MARKET ACCESS DIVISION</td></tr>
          <tr><th class="fw-bold">Section :</th><td>EUROPE & AMERICAS SECTION</td></tr>
          <tr><th class="fw-bold">Unit/Office :</th><td>N/A</td></tr>
          <tr><th class="fw-bold">Indicator :</th><td>Companies Assisted</td></tr>
          <tr><th class="fw-bold">Indicator Type :</th><td>Type 5</td></tr>
          <tr><th class="fw-bold">Annual Target :</th><td>12</td></tr>
          <tr><th class="fw-bold">Metric :</th><td>Companies</td></tr>
          <tr><th class="fw-bold">Achievement Count :</th><td>100</td></tr>
          <tr>
            <th class="fw-bold">Remarks by PMU Admin :</th>
            <td>
              <input type="text" class="form-control" id="achievementInputSaved" value="" placeholder="Enter your remark...">
              <button type="button" class="btn btn-info btn-sm mt-2" id="addRemarkBtn">+ Add Remark</button>
            </td>
          </tr>
        </tbody>
      </table>

      <br>

      <!-- History Button -->
      <div class="d-flex justify-content-end mb-2">
        <button type="button" class="btn btn-outline-secondary">
          <i class="bx bx-history"></i> History
        </button>
      </div>

        <div class="table-responsive">
        <table class="table table-bordered table-sm text-nowrap">
          <thead>
            <tr>
              <th>No.</th>
              <th>Year</th>
              <th>Quarter</th>
              <th>Programme</th>
              <th>Name of Importer</th>
              <th>Name of Malaysian Exporter</th>
              <th>Product/Service</th>
              <th class="text-center">PMU Remarks</th>
              <th class="text-center">
                Accept
                <!-- Select All Accept checkbox here -->
                <input type="checkbox" id="selectAllAccept" title="Select All Accept">
              </th>
              <th class="text-center">Reject</th>
              <th class="text-center">Action</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>1</td>
              <td>2022</td>
              <td>2</td>
              <td>Mentor Program</td>
              <td>ABC Sdn Bhd</td>
              <td>ABC123-Z</td>
              <td>Mentor Program</td>

              <!-- PMU Remarks -->
              <td class="text-center pmu-remark-cell" id="pmu-remark-1" data-visible="false">
                <span class="remark-text d-none"></span>
              </td>

              <!-- Accept checkbox -->
              <td class="text-center">
                <input type="checkbox" name="accept[1]" class="decision-checkbox accept-checkbox" data-row="1">
              </td>

              <!-- Reject checkbox -->
              <td class="text-center">
                <input type="checkbox" name="reject[1]" class="decision-checkbox reject-checkbox" data-row="1">
              </td>

              <!-- Action -->
              <td class="text-center">
                <button type="button" class="btn btn-sm btn-warning editRemarkBtn ms-2 d-none" data-row="1">
                  <i class="bi bi-pencil-square"></i>
                </button>
              </td>
            </tr>

            <!-- You can add more rows here with increasing data-row -->
          </tbody>
        </table>
      </div>

      <!-- Rejection Modal -->
      <div class="modal fade" id="rejectionModal" tabindex="-1" aria-labelledby="rejectionModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="rejectionModalLabel">Rejection Remark</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <textarea id="modalRejectionRemark" class="form-control" placeholder="Enter your rejection remarks..."></textarea>
              <input type="hidden" id="currentRowId">
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-primary" id="saveRejectionRemarkBtn">Save</button>
            </div>
          </div>
        </div>
      </div>

        <!-- Achievement Summary Update -->
        <div class="mt-4">
          <h5>ACHIEVEMENT SUMMARY UPDATE</h5>
          <table class="table table-bordered">
          <thead class="table-light">
            <tr><th>Staff Name</th><th>Date</th></tr></thead>
            <tbody>
              <tr><td>Nurashiqen Shafiqah Jimmy Kayting</td><td>2023-12-29 10:29:56</td></tr>
              <tr><td>Nurashiqen Shafiqah Jimmy Kayting</td><td>2023-12-29 13:42:40</td></tr>
            </tbody>
          </table>
        </div>
    </div>

    <div class="card-footer d-flex justify-content-end gap-2">
      <button type="button" class="btn btn-primary" >Accept</button>
      <!-- <button type="button" class="btn btn-danger" >Reject</button> -->
      <!-- <button type="button" class="btn btn-success" >Save</button> -->
      <a href="{{ url()->previous() }}" class="btn btn-secondary">Back</a>
    </div>
  </div>
</div>
@endsection

<script>
  document.addEventListener('DOMContentLoaded', function () {
  const rejectionModal = new bootstrap.Modal(document.getElementById('rejectionModal'));

  const selectAllAcceptCheckbox = document.getElementById('selectAllAccept');

  function updateSelectAllAcceptCheckbox() {
    const allAcceptCheckboxes = document.querySelectorAll('.accept-checkbox');
    const checkedAcceptCheckboxes = document.querySelectorAll('.accept-checkbox:checked');

    selectAllAcceptCheckbox.checked = allAcceptCheckboxes.length === checkedAcceptCheckboxes.length;
  }

  function toggleCheckboxes(event) {
  const checkbox = event.target;
  const rowId = checkbox.dataset.row;

  const acceptBox = document.querySelector(`.accept-checkbox[data-row="${rowId}"]`);
  const rejectBox = document.querySelector(`.reject-checkbox[data-row="${rowId}"]`);

  if (checkbox.classList.contains('accept-checkbox')) {
    if (checkbox.checked) {
      // Jika Select All tidak ditandakan, hanya benarkan satu tick
      if (!selectAllAcceptCheckbox.checked) {
        // Uncheck semua accept kecuali yang ini
        document.querySelectorAll('.accept-checkbox').forEach(box => {
          if (box !== acceptBox) box.checked = false;
        });
      }

      // Disable reject pada row ini
      rejectBox.checked = false;
      rejectBox.disabled = true;

      // Clear rejection remark
      const remarkCell = document.getElementById(`pmu-remark-${rowId}`);
      const remarkText = remarkCell.querySelector('.remark-text');
      remarkText.textContent = '';
      remarkText.classList.add('d-none');
      remarkCell.setAttribute('data-visible', 'false');

      const actionEditBtn = document.querySelector(`.editRemarkBtn[data-row="${rowId}"]`);
      if (actionEditBtn) actionEditBtn.classList.add('d-none');
    } else {
      // Bila untick, enable balik reject
      rejectBox.disabled = false;
    }

    updateSelectAllAcceptCheckbox();
  }

  else if (checkbox.classList.contains('reject-checkbox')) {
    if (checkbox.checked) {
      acceptBox.checked = false;
      acceptBox.disabled = true;

      // Show rejection modal
      document.getElementById('currentRowId').value = rowId;

      const remarkCell = document.getElementById(`pmu-remark-${rowId}`);
      const remarkText = remarkCell.querySelector('.remark-text');
      document.getElementById('modalRejectionRemark').value = remarkText.textContent.trim();

      rejectionModal.show();
    } else {
      acceptBox.disabled = false;
    }
  }
}


  // Select All Accept checkbox change handler
  selectAllAcceptCheckbox.addEventListener('change', function () {
    if (this.checked) {
      // Check all accept checkboxes
      document.querySelectorAll('.accept-checkbox').forEach(box => {
        box.checked = true;
        box.disabled = false;

        // Disable reject checkbox on the same row
        const rowId = box.dataset.row;
        const rejectBox = document.querySelector(`.reject-checkbox[data-row="${rowId}"]`);
        rejectBox.checked = false;
        rejectBox.disabled = true;

        // Clear rejection remarks
        const remarkCell = document.getElementById(`pmu-remark-${rowId}`);
        const remarkText = remarkCell.querySelector('.remark-text');
        remarkText.textContent = '';
        remarkText.classList.add('d-none');
        remarkCell.setAttribute('data-visible', 'false');

        const actionEditBtn = document.querySelector(`.editRemarkBtn[data-row="${rowId}"]`);
        if (actionEditBtn) actionEditBtn.classList.add('d-none');
      });
    } else {
      // Uncheck all accept checkboxes and enable reject checkboxes
      document.querySelectorAll('.accept-checkbox').forEach(box => {
        box.checked = false;
        box.disabled = false;

        const rowId = box.dataset.row;
        const rejectBox = document.querySelector(`.reject-checkbox[data-row="${rowId}"]`);
        rejectBox.disabled = false;
      });
    }
  });

  // Add event listeners to all checkboxes
  document.querySelectorAll('.accept-checkbox, .reject-checkbox').forEach(cb => {
    cb.addEventListener('change', toggleCheckboxes);
  });

  // Save rejection remark modal
  document.getElementById('saveRejectionRemarkBtn').addEventListener('click', function () {
    const rowId = document.getElementById('currentRowId').value;
    const remark = document.getElementById('modalRejectionRemark').value.trim();

    if (remark === '') {
      alert('Please enter a remark before saving.');
      return;
    }

    const remarkCell = document.getElementById(`pmu-remark-${rowId}`);
    const remarkText = remarkCell.querySelector('.remark-text');
    const actionEditBtn = document.querySelector(`.editRemarkBtn[data-row="${rowId}"]`);

    remarkText.textContent = remark;
    remarkText.classList.remove('d-none');
    remarkCell.style.display = '';
    remarkCell.setAttribute('data-visible', 'true');

    if (actionEditBtn) actionEditBtn.classList.remove('d-none');

    rejectionModal.hide();
  });

  // Edit remark button click opens modal with current remark
  document.querySelectorAll('.editRemarkBtn').forEach(function (btn) {
    btn.addEventListener('click', function () {
      const rowId = this.dataset.row;
      const remarkCell = document.getElementById(`pmu-remark-${rowId}`);
      const existingRemark = remarkCell.querySelector('.remark-text').textContent.trim();

      document.getElementById('currentRowId').value = rowId;
      document.getElementById('modalRejectionRemark').value = existingRemark;
      rejectionModal.show();
    });
  });
});

</script>
