@extends('layouts/contentNavbarLayout')

@section('title', 'Dashboard - Analytics')

@section('vendor-style')
@vite('resources/assets/vendor/libs/apex-charts/apex-charts.scss')
<link href="https://cdnjs.cloudflare.com/ajax/libs/feather-icons/4.29.0/feather.min.css" rel="stylesheet">
@endsection

@section('vendor-script')
@vite('resources/assets/vendor/libs/apex-charts/apexcharts.js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/feather-icons/4.29.0/feather.min.js"></script>
@endsection

@section('page-script')
@vite('resources/assets/js/dashboards-analytics.js')
@endsection

@section('content')
<br><br>

<style>
  .print-only {
    display: none;
  }

  @media print {
    /* Hide all by default */
    body * {
      visibility: hidden !important;
    }

    /* Show only the print section */
    .print-section, .print-section * {
      visibility: visible !important;
    }

    .print-section p.fw-semibold {
    min-height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
  }

    .print-section {
      position: fixed !important;
      top: 40px;
      left: 0;
      width: 100%;
      background: white;
      z-index: 9999;
      padding: 0 20px;
      page-break-inside: avoid;

      /* Scale to fit 1 page */
      transform: scale(0.9);
      transform-origin: top left;
    }

    /* Title styling */
    .print-only {
      display: block !important;
      text-align: center;
      font-size: 20px;
      font-weight: bold;
      margin: 0 0 20px 0;
    }

    /* Horizontal chart layout */
    .print-section .row {
      display: flex !important;
      flex-wrap: nowrap !important;
      justify-content: center !important;
      align-items: flex-start !important;
      gap: 32px;
    }

    .print-section .col-md-4 {
      width: 30% !important;
      max-width: 30% !important;
      display: flex !important;
      flex-direction: column;
      align-items: center;
    }

    /* Align metric text */
    .print-section .d-flex.justify-content-between {
      width: 100%;
      padding: 0 32px;
    }

    /* UI components hidden */
    .card-header,
    .btn,
    .dropdown,
    nav,
    aside,
    footer {
      display: none !important;
    }

    /* Page setup */
    @page {
      size: A4 portrait;
      margin: 10mm;
    }

    html, body {
      height: 100% !important;
      overflow: hidden !important;
      margin: 0 !important;
      padding: 0 !important;
    }
  }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<div class="card mb-4 text-center p-4" style="box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1); border-radius: 12px;">
  <div class="card-body">
    <form id="searchForm" action="{{ route('dashboard-analytics') }}" name="dashboardFilter" id="dashboardFilter" method="post">
      {!! csrf_field() !!}
      <div class="row g-3">

      <!-- Title Section -->
    <div class="flex-grow-1 text-center">
      <h4 class="mb-1 fw-bold text-dark" style="font-size: 28px;">MATRADE'S ACHIEVEMENT</h4>
    </div>

        <div class="col-12 col-md-2">
          <label class="form-label fw-semibold text-start d-block">Year From:</label>
          <select class="form-select" id="yearFrom" name="yearFrom">
            <option value="2025">2025</option>
            <option value="2024">2024</option>
            <option value="2023">2023</option>
            <option value="2022">2022</option>
          </select>
        </div>

        <div class="col-12 col-md-3">
          <label class="form-label fw-semibold text-start d-block">Duration From:</label>
          <select class="form-select" id="durationFrom" name="durationFrom">
            <option value="Q1">Q1 (January - March)</option>
            <option value="Q2">Q2 (April - June)</option>
            <option value="Q3">Q3 (July - September)</option>
            <option value="Q4">Q4 (October - December)</option>
          </select>
        </div>

        <div class="col-12 col-md-2">
          <label class="form-label fw-semibold text-start d-block">Year To:</label>
          <select class="form-select" id="yearTo" name="yearTo">
            <option value="2025">2025</option>
            <option value="2024">2024</option>
            <option value="2023">2023</option>
            <option value="2022">2022</option>
          </select>
        </div>

        <div class="col-12 col-md-3">
          <label class="form-label fw-semibold text-start d-block">Duration To:</label>
          <select class="form-select" id="durationTo" name="durationTo">
            <option value="Q1">Q1 (January - March)</option>
            <option value="Q2">Q2 (April - June)</option>
            <option value="Q3">Q3 (July - September)</option>
            <option value="Q4">Q4 (October - December)</option>
            <option value="H1">H1</option>
            <option value="H2">H2</option>
          </select>
        </div>

        <div class="col-12 col-md-2 d-grid align-items-end">
          <button type="submit" class="btn px-4 py-2" style="background-color: #004B87; color: #FFFFFF; border: none;">
            Search
          </button>
        </div>

      </div>
    </form>
  </div>
</div>

<div class="card mb-4" style="border-radius: 12px; box-shadow: 0 4px 10px rgba(0,0,0,0.1);">
  <div class="card-header bg-white d-flex justify-content-between align-items-center" style="border-radius: 12px 12px 0 0;">

  <div class="flex-grow-1">
          <h4 class="mb-1 fw-bold text-dark">EXPORT PROMOTIONS & EXPORTERS DEVELOPMENT</h4>
    </div>

    <!-- Buttons Section -->
    <div class="ms-auto d-flex align-items-center">
      <button class="btn btn-info btn-sm me-2" onclick="printPage()">
        <i data-feather="printer" class="me-1"></i>Print
      </button>
      <div class="btn-group">
        <button class="btn btn-danger btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
          <i data-feather="download" class="me-1"></i>Export
        </button>
        <ul class="dropdown-menu shadow" aria-labelledby="exportDropdown">
          <li><a class="dropdown-item" href="/export/excel"><i class="fas fa-file-excel me-2 text-success"></i>EXCEL</a></li>
          <li><a class="dropdown-item" href="/export/pdf"><i class="fas fa-file-pdf me-2 text-danger"></i>PDF</a></li>
          <li><a class="dropdown-item" href="/export/word"><i class="fas fa-file-word me-2 text-primary"></i>WORD</a></li>
          <li><a class="dropdown-item" href="/export/csv"><i class="fas fa-file-image me-2 text-warning"></i>JPG</a></li>
        </ul>
      </div>
    </div>
  </div>

  <!-- Divider Line -->
  <!-- <div class="px-3">
    <hr style="border: none; border-top: 1px solid #ddd; margin: 8px 0 16px 0;">
  </div> -->

  <div class="card-body print-section">
    <h2 class="print-only text-center fw-bold mb-4">MATRADE Achievement Quarter 1 - Quarter 2</h2>

    <div class="row gy-4">

      <!-- No. of Programme -->
      <div class="col-md-4 d-flex">
        <div class="text-center flex-fill p-3" style="border: 1px solid #f0f0f0; border-radius: 10px;">
          <p class="fw-semibold text-dark mb-3" style="font-size: 18px;">No. of Programme</p>
          <div id="chart-programme" style="height: 180px;"></div>
          <div class="d-flex justify-content-between align-items-center px-3 mt-3">
            <div class="d-flex align-items-center">
              <span class="me-2" style="background-color: #e0e0e0; width: 14px; height: 14px; border-radius: 50%; display: inline-block;"></span>
                  <span class="fw-semibold" style="color: #444444; font-size: 20px;">Target</span>
            </div>
          <span class="fw-bold text-dark" style="font-size: 18px;">{{ $matrade_achievement->programme->total_target_short }}</span>
          </div>
          <div class="d-flex justify-content-between align-items-center px-3 mt-2">
            <div class="d-flex align-items-center">
              <span class="me-2" style="background-color: #BDA522; width: 14px; height: 14px; border-radius: 50%; display: inline-block;"></span>
                  <span class="fw-semibold" style="color: #BDA522; font-size: 20px;">Achievement</span>
            </div>
            <span class="fw-bold text-dark" style="font-size: 18px;">{{ $matrade_achievement->programme->total_achievement_short }}</span>
          </div>
        </div>
      </div>

      <!-- Export Sales -->
      <div class="col-md-4 d-flex">
        <div class="text-center flex-fill p-3" style="border: 1px solid #f0f0f0; border-radius: 10px;">
          <p class="fw-semibold text-dark mb-3" style="font-size: 18px;">Export Sales (RM)</p>
          <div id="chart-sales" style="height: 180px;"></div>
          <div class="d-flex justify-content-between align-items-center px-3 mt-3">
            <div class="d-flex align-items-center">
              <span class="me-2" style="background-color: #e0e0e0; width: 14px; height: 14px; border-radius: 50%; display: inline-block;"></span>
              <span class="fw-semibold" style="color: #444444; font-size: 20px;">Target</span>
            </div>
            <span class="fw-bold text-dark" style="font-size: 18px;">{{ $matrade_achievement->export_sales_rm->total_target_short }}</span>
          </div>
          <div class="d-flex justify-content-between align-items-center px-3 mt-2">
            <div class="d-flex align-items-center">
              <span class="me-2" style="background-color: #18A1CD; width: 14px; height: 14px; border-radius: 50%; display: inline-block;"></span>
              <span class="fw-semibold" style="color: #18A1CD; font-size: 20px;">Achievement</span>
            </div>
            <span class="fw-bold text-dark" style="font-size: 18px;">{{ $matrade_achievement->export_sales_rm->total_achievement_short }}</span>
          </div>
        </div>
      </div>

      <!-- No. of Companies Assisted -->
      <div class="col-md-4 d-flex">
        <div class="text-center flex-fill p-3" style="border: 1px solid #f0f0f0; border-radius: 10px;">
          <p class="fw-semibold text-dark mb-3" style="font-size: 18px;">No. of Companies Assisted</p>
          <div id="chart-companies" style="height: 180px;"></div>
          <div class="d-flex justify-content-between align-items-center px-3 mt-3">
            <div class="d-flex align-items-center">
              <span class="me-2" style="background-color: #e0e0e0; width: 14px; height: 14px; border-radius: 50%; display: inline-block;"></span>
              <span class="fw-semibold" style="color: #444444; font-size: 20px;">Target</span>
            </div>
            <span class="fw-bold text-dark" style="font-size: 18px;">{{ $matrade_achievement->company_assisted->total_target_short }}</span>
          </div>
          <div class="d-flex justify-content-between align-items-center px-3 mt-2">
            <div class="d-flex align-items-center">
              <span class="me-2" style="background-color: #BB1386; width: 14px; height: 14px; border-radius: 50%; display: inline-block;"></span>
              <span class="fw-semibold" style="color: #BB1386; font-size: 20px;">Achievement</span>
            </div>
            <span class="fw-bold text-dark" style="font-size: 18px;">{{ $matrade_achievement->company_assisted->total_achievement_short }}</span>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>


<div class="card mb-4 shadow-sm">
  <div class="card-header d-flex align-items-center">
    <h4 class="fw-bold mb-0 text-dark">
      EXPORT PROMOTIONS
      <a href="{{ route('export-promotion', [
                  'export_promotions' => encrypt(json_encode($export_promotions)),
                  'date_range' => encrypt(json_encode($date_range))
                ]) }}" class="text-decoration-none ms-2" title="Go to Export Promotion">
        <i class="bx bx-link-external" style="font-size: 0.9rem;"></i>
      </a>
    </h4>
  </div>



  <div class="card-body">

    <!-- SECTION 1: No. of Programme -->
<div class="mb-4 px-4">
  <div class="mb-2">
    <p class="fw-semibold text-dark mb-1 text-center">No. of Programme</p>
    <div class="progress" style="height: 25px; border-radius: 13px;">
      <div class="progress-bar progress-bar-striped progress-bar-animated"
        role="progressbar"
        style="width: {{ $export_promotions->programme->percentage }}%; background-color: #BDA522;"
        aria-valuenow="{{ $export_promotions->programme->total_achievement }}"
        aria-valuemin="0"
        aria-valuemax="{{ $export_promotions->programme->total_target }}">
        {{ $export_promotions->programme->percentage }}%
      </div>
    </div>
  </div>
  <div class="d-flex justify-content-between align-items-center">
    <div class="d-flex flex-column text-start">
      <span class="fw-semibold" style="color: #2f3d4bff;">Achievement</span>
      <span class="fw-bold text-dark">{{ $export_promotions->programme->total_achievement_short }}</span>
    </div>
    <div class="d-flex flex-column text-end">
      <span class="fw-semibold" style="color: #2f3d4bff;">Target</span>
      <span class="fw-bold text-dark">{{ $export_promotions->programme->total_target_short }}</span>
    </div>
  </div>
</div>


<!-- SECTION 2: Export Sales -->
<div class="mb-4 px-4">
  <div class="mb-2">
    <p class="fw-semibold text-dark mb-1 text-center">Export Sales (RM)</p>
    <div class="progress" style="height: 25px; border-radius: 13px;">
      <div class="progress-bar progress-bar-striped progress-bar-animated"
        role="progressbar"
        style="width: {{ $export_promotions->export_sales_rm->percentage }}%; background-color: #18A1CD;"
        aria-valuenow="{{ $export_promotions->export_sales_rm->total_achievement }}"
        aria-valuemin="0"
        aria-valuemax="{{ $export_promotions->export_sales_rm->total_target }}">
          {{ $export_promotions->export_sales_rm->percentage }}%
      </div>
    </div>
  </div>
  <div class="d-flex justify-content-between align-items-center">
    <div class="d-flex flex-column text-start">
      <span class="fw-semibold" style="color: #2f3d4bff;">Achievement</span>
      <span class="fw-bold text-dark">{{ $export_promotions->export_sales_rm->total_achievement_short }}</span>
    </div>
    <div class="d-flex flex-column text-end">
      <span class="fw-semibold" style="color: #2f3d4bff;">Target</span>
      <span class="fw-bold text-dark">{{ $export_promotions->export_sales_rm->total_target_short }}</span>
    </div>
  </div>
</div>

<!-- SECTION 3: Companies Assisted -->
<div class="mb-4 px-4">
  <div class="mb-2">
    <p class="fw-semibold text-dark mb-1 text-center">No. of Companies Assisted</p>
    <div class="progress" style="height: 25px; border-radius: 13px;">
      <div class="progress-bar progress-bar-striped progress-bar-animated"
        role="progressbar"
        style="width: {{ $export_promotions->company_assisted->percentage }}%; background-color: #BB1386;"
        aria-valuenow="{{ $export_promotions->company_assisted->total_achievement }}"
        aria-valuemin="0"
        aria-valuemax="{{ $export_promotions->company_assisted->total_target }}">
        {{ $export_promotions->company_assisted->percentage }}%
      </div>
    </div>
  </div>
  <div class="d-flex justify-content-between align-items-center">
    <div class="d-flex flex-column text-start">
       <span class="fw-semibold" style="color: #2f3d4bff;">Achievement</span>
      <span class="fw-bold text-dark">{{ $export_promotions->export_sales_rm->total_achievement_short }}</span>
    </div>
    <div class="d-flex flex-column text-end">
       <span class="fw-semibold" style="color: #2f3d4bff;">Target</span>
      <span class="fw-bold text-dark">{{ $export_promotions->export_sales_rm->total_target_short }}</span>
    </div>
  </div>
</div>
</div>
</div>




<div class="card mb-4 shadow-sm">
  <div class="card-header d-flex align-items-center">
    <h4 class="fw-bold mb-0 text-dark text-center">
      EXPORTERS DEVELOPMENT
      <a href="{{ route('exporters-development',[
                  'exporters_development' => encrypt(json_encode($exporters_development)),
                  'date_range' => encrypt(json_encode($date_range))
                ]) }}" class="text-decoration-none ms-2" title="Go to Exporters Development">
        <i class="bx bx-link-external" style="font-size: 0.9rem;"></i>
      </a>
    </h4>
  </div>

 <div class="card-body">

  <!-- SECTION 1: No. of Programme -->
  <div class="mb-4 px-4">
    <div class="mb-2">
      <p class="fw-semibold text-dark mb-1 text-center">No. of Programme</p>
    <div class="progress" style="height: 25px; border-radius: 13px;">
        <div class="progress-bar progress-bar-striped progress-bar-animated"
          role="progressbar"
          style="width: {{ $exporters_development->programme->percentage }}%; background-color: #BDA522;"
          aria-valuenow="{{ $exporters_development->programme->total_achievement }}"
          aria-valuemin="0"
          aria-valuemax="{{ $exporters_development->programme->total_target }}">
          {{ $exporters_development->programme->percentage }}%
        </div>
      </div>
    </div>
    <div class="d-flex justify-content-between align-items-center">
      <div class="d-flex flex-column text-start">
         <span class="fw-semibold" style="color: #2f3d4bff;">Achievement</span>
        <span class="fw-bold text-dark">{{ $exporters_development->programme->total_achievement_short }}</span>
      </div>
      <div class="d-flex flex-column text-end">
         <span class="fw-semibold" style="color: #2f3d4bff;">Target</span>
        <span class="fw-bold text-dark">{{ $exporters_development->programme->total_target_short }}</span>
      </div>
    </div>
  </div>

  <!-- SECTION 2: Export Sales -->
  <div class="mb-4 px-4">
    <div class="mb-2">
       <p class="fw-semibold text-dark mb-1 text-center">Export Sales (RM)</p>
    <div class="progress" style="height: 25px; border-radius: 13px;">
        <div class="progress-bar progress-bar-striped progress-bar-animated"
          role="progressbar"
          style="width: {{ $exporters_development->export_sales_rm->percentage }}%; background-color: #18A1CD;"
          aria-valuenow="{{ $exporters_development->export_sales_rm->total_achievement }}"
          aria-valuemin="0"
          aria-valuemax="{{ $exporters_development->export_sales_rm->total_target }}">
          {{ $exporters_development->export_sales_rm->percentage }}%
        </div>
      </div>
    </div>
    <div class="d-flex justify-content-between align-items-center">
      <div class="d-flex flex-column text-start">
         <span class="fw-semibold" style="color: #2f3d4bff;">Achievement</span>
        <span class="fw-bold text-dark">{{ $exporters_development->export_sales_rm->total_achievement_short }}</span>
      </div>
      <div class="d-flex flex-column text-end">
        <span class="fw-semibold" style="color: #2f3d4bff;">Target</span>
        <span class="fw-bold text-dark">{{ $exporters_development->export_sales_rm->total_target_short }}</span>
      </div>
    </div>
  </div>

  <!-- SECTION 3: Companies Assisted -->
  <div class="mb-4 px-4">
    <div class="mb-2">
      <p class="fw-semibold text-dark mb-1 text-center">No. of Companies Assisted</p>
    <div class="progress" style="height: 25px; border-radius: 13px;">
        <div class="progress-bar progress-bar-striped progress-bar-animated"
          role="progressbar"
          style="width: {{ $exporters_development->company_assisted->percentage }}%; background-color: #BB1386;"
          aria-valuenow="{{ $exporters_development->company_assisted->total_achievement }}"
          aria-valuemin="0"
          aria-valuemax="{{ $exporters_development->company_assisted->total_target }}">
          {{ $exporters_development->company_assisted->percentage }}%
        </div>
      </div>
    </div>
    <div class="d-flex justify-content-between align-items-center">
      <div class="d-flex flex-column text-start">
         <span class="fw-semibold" style="color: #2f3d4bff;">Achievement</span>
        <span class="fw-bold text-dark">{{ $exporters_development->company_assisted->total_achievement_short }}</span>
      </div>
      <div class="d-flex flex-column text-end">
         <span class="fw-semibold" style="color: #2f3d4bff;">Target</span>
        <span class="fw-bold text-dark">{{ $exporters_development->company_assisted->total_target_short }}</span>
      </div>
    </div>
  </div>

</div>

    <!-- Bootstrap Buttons - Color Palette Display -->
    <!-- <button type="button" class="btn btn-primary">Primary</button>
    <button type="button" class="btn btn-secondary">Secondary</button>
    <button type="button" class="btn btn-success">Success</button>
    <button type="button" class="btn btn-danger">Danger</button>
    <button type="button" class="btn btn-warning">Warning</button>
    <button type="button" class="btn btn-info">Info</button> -->
    <!-- <button type="button" class="btn btn-light">Light</button>
    <button type="button" class="btn btn-dark">Dark</button>
    <button type="button" class="btn btn-link">Link</button> -->

    <link href="https://fonts.googleapis.com/css2?family=Roboto&display=swap" rel="stylesheet">




    <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>
    <script>
      document.addEventListener('DOMContentLoaded', function () {
      function createPieChart(id, achieved, total, achievedColor, targetColor) {
      const chart = echarts.init(document.getElementById(id));
      const percentage = ((achieved / total) * 100).toFixed(0);
      //const percentage = total > 0 ? ((achieved / total) * 100).toFixed(0) : 0;
      chart.setOption({
        tooltip: {
          trigger: 'item',
          formatter: (params) => {
            if (params.name === 'Achieved') {
              return `<strong>Achievement:</strong> ${achieved}`;
            } else {
              return `<strong>Target:</strong> ${total}`;
            }
          }
        },
        series: [{
          name: id,
          type: 'pie',
          radius: ['65%', '80%'],
          avoidLabelOverlap: false,
          label: {
            show: true,
            position: 'center',
            formatter: percentage + '%',
            fontSize: 22,
            fontWeight: 'bold',
            color: achievedColor
          },
          emphasis: {
            label: {
              show: true,
              fontSize: 24,
              fontWeight: 'bold'
            }
          },
          labelLine: { show: false },
          data: [
            { value: achieved, name: 'Achieved', itemStyle: { color: achievedColor } },
            { value: total - achieved, name: 'Target', itemStyle: { color: targetColor } }
          ]
        }]
      });
    }


        createPieChart('chart-programme', {{ $matrade_achievement->programme->total_achievement }}, {{ $matrade_achievement->programme->total_target == 0 }}, '#BDA522', '#e0e0e0');
        createPieChart('chart-sales', {{ $matrade_achievement->export_sales_rm->total_achievement }}, {{ $matrade_achievement->export_sales_rm->total_target == 0 ? 1 : $matrade_achievement->export_sales_rm->total_target }}, '#18A1CD  ', '#e0e0e0');
        createPieChart('chart-companies', {{ $matrade_achievement->company_assisted->total_achievement }}, {{ $matrade_achievement->company_assisted->total_target == 0 ? 1 : $matrade_achievement->company_assisted->total_target }}, '#BB1386', '#e0e0e0');

      });
    </script>

<script>
  function printPage() {
    window.print();
  }

  // Initialize feather icons after DOM is loaded
  document.addEventListener('DOMContentLoaded', function() {
    feather.replace();
  });
</script>


<!-- Script for Export Promotions -->
<script>
      document.addEventListener('DOMContentLoaded', function () {
        function createPieChart(id, achieved, total, achievedColor, targetColor) {
      const chart = echarts.init(document.getElementById(id));
      const percentage = ((achieved / total) * 100).toFixed(0);
      chart.setOption({
        tooltip: {
          trigger: 'item',
          formatter: (params) => {
            if (params.name === 'Achieved') {
              return `<strong>Achievement:</strong> ${achieved}`;
            } else {
              return `<strong>Target:</strong> ${total}`;
            }
          }
        },
        series: [{
          name: id,
          type: 'pie',
          radius: ['65%', '80%'],
          avoidLabelOverlap: false,
          label: {
            show: true,
            position: 'center',
            formatter: percentage + '%',
            fontSize: 22,
            fontWeight: 'bold',
            color: achievedColor
          },
          emphasis: {
            label: {
              show: true,
              fontSize: 24,
              fontWeight: 'bold'
            }
          },
          labelLine: { show: false },
          data: [
            { value: achieved, name: 'Achieved', itemStyle: { color: achievedColor } },
            { value: total - achieved, name: 'Target', itemStyle: { color: targetColor } }
          ]
        }]
      });
    }


        // createPieChart('chart-programme-ep', 76, 239, '#BDA522', '#e0e0e0');
        // createPieChart('chart-sales-ep', 1.72, 2.92, '#18A1CD  ', '#e0e0e0');
        // createPieChart('chart-companies-ep', 4477, 5726, '#BB1386   ', '#e0e0e0');

      });
    </script>

    <!-- Script for Exporters Development -->
    <script>
      document.addEventListener('DOMContentLoaded', function () {
        function createPieChart(id, achieved, total, achievedColor, targetColor) {
      const chart = echarts.init(document.getElementById(id));
      const percentage = ((achieved / total) * 100).toFixed(0);
      chart.setOption({
        tooltip: {
          trigger: 'item',
          formatter: (params) => {
            if (params.name === 'Achieved') {
              return `<strong>Achievement:</strong> ${achieved}`;
            } else {
              return `<strong>Target:</strong> ${total}`;
            }
          }
        },
        series: [{
          name: id,
          type: 'pie',
          radius: ['65%', '80%'],
          avoidLabelOverlap: false,
          label: {
            show: true,
            position: 'center',
            formatter: percentage + '%',
            fontSize: 22,
            fontWeight: 'bold',
            color: achievedColor
          },
          emphasis: {
            label: {
              show: true,
              fontSize: 24,
              fontWeight: 'bold'
            }
          },
          labelLine: { show: false },
          data: [
            { value: achieved, name: 'Achieved', itemStyle: { color: achievedColor } },
            { value: total - achieved, name: 'Target', itemStyle: { color: targetColor } }
          ]
        }]
      });
    }


        // createPieChart('chart-programme-ed', 76, 239, '#BDA522', '#e0e0e0');
        // createPieChart('chart-sales-ed', 1.72, 2.92, '#18A1CD  ', '#e0e0e0');
        // createPieChart('chart-companies-ed', 4477, 5726, '#BB1386   ', '#e0e0e0');

      });
    </script>

@endsection
