@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Achievement - Type 4')

@section('content')
<br>
<div class="container my-4">
  <div class="card">
    <div class="card-header">
      <h4 class="mb-0">Achievement Details (Type 4)</h4>
    </div>

    <div class="card-body">
      <table class="table table-bordered">
        <tbody>
         <tr><th class="w-50 fw-bold">Year :</th><td>2022</td></tr>
          <tr><th class="fw-bold">Quarter :</th><td>2</td></tr>
          <tr><th class="fw-bold">Division :</th><td>EXPORTS PROMOTION & MARKET ACCESS DIVISION</td></tr>
          <tr><th class="fw-bold">Section :</th><td>EUROPE & AMERICAS SECTION</td></tr>
          <tr><th class="fw-bold">Unit/Office :</th><td>New York</td></tr>
          <tr><th class="fw-bold">Indicator :</th><td>Media Engagement</td></tr>
          <tr><th class="fw-bold">Indicator Type :</th><td>Type 4</td></tr>
          <tr><th class="fw-bold">Annual Target :</th><td>12</td></tr>
          <tr><th class="fw-bold">Metric :</th><td>Media Coverage</td></tr>
          <tr>
            <th class="fw-bold">Achievement Count :</th>
            <td>100</td>
          </tr>
          <tr><th class="fw-bold">Remarks by PMU Admin :</th><td></td></tr>
        </tbody>
      </table>

      <br><br>
      <!-- Responsive Table Section -->
      <div class="table-responsive">
        <table class="table table-bordered table-sm text-nowrap">
          <thead>
            <tr>
              <th><input type="checkbox" id="checkAllType4"></th>
              <th>No.</th>
              <th>Year</th>
              <th>Quarter</th>
              <th>
                <label style="display: flex; align-items: center; gap: 8px;">
                  <span>Programme</span>
                  <input type="radio" name="programme_type4" value="programme">
                </label>
              </th>
              <th>
                <label style="display: flex; align-items: center; gap: 8px;">
                  <span>Name of Company</span>
                  <input type="radio" name="programme_type4" value="company">
                </label>
              </th>
              <th>
                <label style="display: flex; align-items: center; gap: 8px;">
                  <span>Registration Number (ROC/ROB)</span>
                  <input type="radio" name="programme_type4" value="registration">
                </label>
              </th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td><input type="checkbox" class="rowCheckboxType4"></td>
              <td>1</td>
              <td>2025</td>
              <td><input type="text" class="form-control" name="achievement_count[]" value="0"></td>
              <td><input type="text" class="form-control" name="programme[]"></td>
              <td><input type="text" class="form-control" name="company_name[]"></td>
              <td><input type="text" class="form-control" name="registration_number[]"></td>
              <td>
                <input type="file" name="supporting_doc[]" style="display: none;" class="fileInputType4">
                <div class="d-flex flex-column mt-2 gap-2">
                  <button class="btn btn-danger btn-sm resetBtnType4" style="display: none;">Reset</button>
                  <button class="btn btn-danger btn-sm deleteBtnType4" style="display: none;">Delete</button>
                </div>
              </td>
            </tr>
          </tbody>
        </table>
      </div>


      <div class="d-flex justify-content-end">
        <button type="button" class="btn btn-info btn-sm mt-2" id="addRowBtn">+ Add Row</button>
      </div>
    </div>

    <div class="card-footer d-flex justify-content-end gap-2">
      <button type="button" class="btn btn-primary ms-2" id="saveBtn">Save</button>
      <a href="{{ url()->previous() }}" class="btn btn-secondary">Back</a>
    </div>
  </div>
</div>
@endsection
