@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Achievement')

@section('content')
<br>
<div class="container-fluid my-4 px-3">
  <div class="card mx-auto" style="max-width: 98%;">
    <div class="card-header">
      <h4 class="mb-0">Manage Indicator Type 5</h4>
    </div>

    <div class="card-body">
      <!-- START: Indicator Details Section -->
      <div class="mb-4">

        <!-- Division Info -->
        <div class="row mb-3">
          <div class="col-md-4">
            <label class="form-label">Division:</label>
            <input type="text" class="form-control" value="EXPORT PROMOTION & MARKET ACCESS" readonly>
          </div>
          <div class="col-md-4">
            <label class="form-label">Section:</label>
            <input type="text" class="form-control" value="ASEAN & OCENIA" readonly>
          </div>
          <div class="col-md-4">
            <label class="form-label">Unit / Offices:</label>
            <input type="text" class="form-control" value="N/A" readonly>
          </div>
        </div>

        <!-- Indicator Table -->
        <div class="table-responsive mb-4">
          <table class="table table-bordered text-center small align-middle">
            <thead class="table-light">
              <tr>
                <th>Indicator</th>
                <th>Indicator Description</th>
                <th>Submission</th>
                <th>Annual Target</th>
                <th>Metric</th>
                <th>Category</th>
                <th>Output/Outcome</th>
                <th>Component Achievement</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>Export Sales</td>
                <td style="text-align: justify;">Export sales derived from current year promotion activities implemented by Sectoral, Market Section (incl. collaboration prog with other Ministry, Agency, Industry Association, etc). 

All programmes & export sales are to be reported in TPMS (TF, EAM, INSP, TIM,  others where applicable). Details are to be keyed in before the end of each quarter for it to be accounted for achievement. 

To ensure data are accurate & consistent at various levels of reporting, PMU will cross check Section/ Office submission in excel sheets against reports provided by the respective secretariat (if applicable).

*Note - based on outcome projected on approved AWP 2025</td>
                <td>Quarterly</td>
                <td>1840000000</td>
                <td>RM</td>
                <td>Customer</td>
                <td>Outcome</td>
                <td>Export Promotion Market Access</td>
              </tr>
            </tbody>
          </table>
        </div>

        <!-- Query Input -->
        <p class="fw-semibold">Query:</p>
        <div class="mb-3">
          <textarea id="sqlEditor4" class="form-control" rows="10" style="background-color: #1e1e1e; color: #fff; font-family: monospace;"></textarea>
        </div>
        <div class="text-end mb-4">
          <button type="button" class="btn btn-primary">Test Query</button>
        </div>

        <!-- Achievement Table -->
        <div class="table-responsive">
          <table class="table table-bordered align-middle text-center small">
            <thead class="table-light">
              <tr>
                <th>Year</th>
                <th>Quarter/Month Group</th>
                <th>Achievement Count</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>
                  <input type="text" class="form-control text-center" value="2024" readonly>
                </td>
                <td>
                  <input type="text" class="form-control text-center" placeholder="Q1 / Jan">
                </td>
                <td>
                  <input type="text" class="form-control text-center" placeholder="">
                </td>
              </tr>
            </tbody>
          </table>
        </div>

      </div>
      <!-- END: Indicator Details Section -->

      <div class="d-flex justify-content-end gap-2">
        <button type="button" class="btn btn-primary">Save</button>
      </div>
    </div> <!-- end card-body -->
  </div> <!-- end card -->
</div> <!-- end container -->
@endsection
