@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Achievement')

@section('content')
<style>
  .modal-content {
    max-height: 90vh;
    overflow-y: auto;
  }
</style>

<script src="https://unpkg.com/feather-icons"></script>
<br><br>
    <div class="row">
      <div class="col-12">
        <h4 class="fw-bold py-2 mb-3">Annual Programme</h4>
      </div>
    </div>

<div class="container my-1">
  <div class="card">
    <div class="card-header">

        <div class="row mb-3">
            <div class="col-md-3">
                <label for="year" class="form-label">Year:</label>
                <select id="year" class="form-select">
                    @for ($y = now()->year; $y >= 2020; $y--)
                        <option value="{{ $y }}">{{ $y }}</option>
                    @endfor
                </select>
            </div>
            <div class="col-md-4">
                <label for="groupMonth" class="form-label">Group of Month:</label>
                <select id="groupMonth" class="form-select">
                    <option value="Q1">Q1 (January - March)</option>
                    <option value="Q2">Q2 (April - June)</option>
                    <option value="Q3">Q3 (July - September)</option>
                    <option value="Q4">Q4 (October - December)</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-primary w-100" data-bs-toggle="modal" data-bs-target="#programmeModal">
                  Add Programme
                </button>
            </div>
        </div>

        <br>

        <div class="table-responsive">
            <table class="table table-bordered">
                <thead class="table-light">
                    <tr>
                        <th>Programme</th>
                        <th>Budgets</th>
                        <th>Sales</th>
                        <th>Activities</th>
                        <th>Participants</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                      <td>eBizMatch</td>
                      <td>0.00</td>
                      <td>5,725,353,247.18</td>
                      <td>1</td>
                      <td>427</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


          <!-- Modal -->
          <div class="modal fade" id="programmeModal" tabindex="-1" aria-labelledby="programmeModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
              <div class="modal-content">
                <form action="" method="POST">
                  @csrf
                  <div class="modal-header">
                    <h5 class="modal-title" id="programmeModalLabel">Annual Work Programme</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>

                  <div class="modal-body row g-3">
                    <div class="col-md-6">
                      <label>Year:</label>
                      <input type="text" name="year" class="form-control" value="{{ now()->year }}" readonly>
                    </div>
                    <div class="col-md-6">
                      <label>Group of Month:</label>
                      <input type="text" name="group_month" class="form-control" value="1" readonly>
                    </div>
                    <div class="col-md-12">
                      <label>Programme:</label>
                      <select name="programme_id" class="form-select" required>
                        <option value="">Please select</option>
                        
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label>Budget:</label>
                      <input type="number" step="0.01" name="budget" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                      <label>Sales:</label>
                      <input type="number" step="0.01" name="sales" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                      <label>Activities:</label>
                      <input type="number" name="activities" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                      <label>Participants:</label>
                      <input type="number" name="participants" class="form-control" required>
                    </div>
                  </div>

                  <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <!-- <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button> -->
                  </div>
                </form>
              </div>
            </div>
          </div>
</div>
</div>
</div>
@endsection