@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Achievement')

@section('content')
 @php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'KPI Achievement'],
    ['label' => 'Companies by Sectors']
  ];
@endphp

@include('layouts.partials.page-header', [
  'title' => 'Companies by Sectors',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))->render()
])
<script src="{{ asset('js/kpiAchievement.js') }}"></script>

<!-- SweetAlert2 CDN --> 
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script> 


<!-- Bootstrap Bundle with Popper.js (for modal functionality) --> 
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script> 

<!-- Feather Icons -->
<script src="https://unpkg.com/feather-icons"></script> 

<script>
    feather.replace(); // untuk aktifkan feather icons
</script>

<style>
  .swal2-container {
    z-index: 11000 !important;
  }

  #achievementDetailsPage {
    transition: all 0.4s ease;
  }
  
  .modal-backdrop {
    display: none !important;
  }
  
  body.modal-open {
    overflow: auto !important;
    padding-right: 0 !important;
  }
</style>
<br>
  <div class="nav-align-top mb-1">
    <ul class="nav nav-pills mb-1" role="tablist">
      
    </ul>

    <div class="tab-content">
    <script src="{{ asset('js/kpiAchievement.js') }}"></script>

<!-- SweetAlert2 CDN --> 
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script> 


<!-- Bootstrap Bundle with Popper.js (for modal functionality) --> 
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script> 

<!-- Feather Icons -->
<script src="https://unpkg.com/feather-icons"></script> 

<script>
    feather.replace(); // untuk aktifkan feather icons
</script>

<!-- Companies By Sectors Tab Content -->

<form method="POST" action="#">
  @csrf
  <div class="row mb-4">
    <div class="col-md-4">
      <label for="year" class="form-label fw-bold">Year</label>
      <select id="year" name="year" class="form-select">
        <option selected disabled>Choose year</option>
        @for ($i = now()->year; $i >= 2020; $i--)
          <option value="{{ $i }}">{{ $i }}</option>
        @endfor
      </select>
    </div>
    <div class="col-md-4">
      <label for="duration" class="form-label fw-bold">Durations</label>
      <select id="duration" name="duration" class="form-select">
        <option selected disabled>Choose duration</option>
        <option value="Q1">Q1</option>
        <option value="Q2">Q2</option>
        <option value="Q3">Q3</option>
        <option value="Q4">Q4</option>
      </select>
    </div>
    <div class="col-md-4">
      <label for="programme" class="form-label fw-bold">Exporter Development Programme</label>
      <select id="programme" name="programme" class="form-select">
        <option selected disabled>Select programme</option>
        <option value="EPC">Export Promotion Campaign</option>
        <option value="MTTP">Market Training & Trade Programme</option>
        <option value="EDTP">Export Development Training Programme</option>
      </select>
    </div>
  </div>
</form>

<!-- Table Section -->
<div class="table-responsive text-nowrap">
  <table class="table">
    <thead>
      <tr class="text-nowrap">
        <th>Companies by Sector</th>
        <th>Total Companies</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>ELECTRICAL & ELECTRONIC, ICT, MACHINERY AND EQUIPMENT SECTION</td>
        <td><input type="number" class="form-control" value="0" /></td>
      </tr>
      <tr>
        <td>TRANSPORT & LOGISTICS SECTION</td>
        <td><input type="number" class="form-control" value="0" /></td>
      </tr>
      <tr>
        <td>OIL & GAS, CHEMICAL AND ENERGY SECTION</td>
        <td><input type="number" class="form-control" value="0" /></td>
      </tr>
      <tr>
        <td>HALAL, F&B, AND AGRO-BASED SECTION</td>
        <td><input type="number" class="form-control" value="0" /></td>
      </tr>
      <tr>
        <td>LIFESTYLE & LIFE SCIENES SECTION</td>
        <td><input type="number" class="form-control" value="0" /></td>
      </tr>
      <tr>
        <td>CONSTRUCTION & BUSINESS SERVICESS SECTION</td>
        <td><input type="number" class="form-control" value="0" /></td>
      </tr>
    </tbody>
  </table>
</div>

<!-- Save Button -->
<div class="d-flex justify-content-end mt-3">
  <button type="button" class="btn btn-primary" id="saveCompaniesBtn">Save</button>
</div>

</div>

@endsection