<script>
  // Function to open edit modal with user data
  function openEditUserModal(userId) {
    // Fetch user data by ID (replace with your actual data fetching method)
    const userData = getUserDataById(userId);

    // Populate form fields
    document.getElementById('name').value = userData.name;
    document.getElementById('email').value = userData.email;
    document.getElementById('division').value = userData.division;
    document.getElementById('section').value = userData.section;
    document.getElementById('unitOffice').value = userData.unitOffice;
    document.getElementById('accessStatus').value = userData.accessStatus;

    // Show the modal
    const editModal = new bootstrap.Modal(document.getElementById('editUserModal'));
    editModal.show();
  }

  // Example function to get user data by ID (replace with your actual implementation)
  function getUserDataById(userId) {
    // This is just sample data - replace with actual data retrieval
    const users = [{
        id: 1,
        name: 'STAGING KPI 15',
        email: 'staging01@gmail.io',
        division: 'PROMOTION & MARKET ACCESS DIVISION',
        section: 'EUROPE & AMERICAS SECTION',
        unitOffice: 'N/A',
        roles: ['TC Admin', 'MATRADE Employee'],
        accessStatus: 'Active'
      },
      {
        id: 2,
        name: 'STAGING KPI 05',
        email: 'staging05@gmail.io',
        division: 'EXPORTS PROMOTION & MARKET ACCESS DIVISION',
        section: 'EUROPE & AMERICAS SECTION',
        unitOffice: 'N/A',
        roles: ['MATRADE Employee', 'Regional Admin'],
        accessStatus: 'Active'
      },
      // Add more user data as needed
    ];

    return users.find(user => user.id === userId) || {};
  }

  // Function to update permissions based on selected role
  function updatePermissions() {
    const role = document.getElementById('userRole').value;

    // Reset all checkboxes
    const checkboxes = document.querySelectorAll('.form-check-input');
    checkboxes.forEach(checkbox => {
      checkbox.checked = false;
      checkbox.disabled = true;
    });

    // Set permissions based on selected role
    if (role === 'itAdmin') {
      // Enable KPI Administration section
      document.getElementById('kpiAdminCheck').checked = true;
      document.getElementById('kpiAdminCheck').disabled = false;

      // Enable specific permissions
      document.getElementById('viewKpiIndicatorType').checked = true;
      document.getElementById('viewKpiIndicatorType').disabled = false;

      // You can add more role-specific permissions here
    } else if (role === 'management') {
      // Management permissions
      document.getElementById('kpiDashboardCheck').checked = true;
      document.getElementById('kpiDashboardCheck').disabled = false;
      document.getElementById('kpiReportingCheck').checked = true;
      document.getElementById('kpiReportingCheck').disabled = false;
      document.getElementById('viewReport').checked = true;
      document.getElementById('viewReport').disabled = false;
      document.getElementById('printReport').checked = true;
      document.getElementById('printReport').disabled = false;
    } else if (role === 'matradeEmployee') {
      // MATRADE Employee permissions
      document.getElementById('kpiAchievementCheck').checked = true;
      document.getElementById('kpiAchievementCheck').disabled = false;
      document.getElementById('addKpiEntries').checked = true;
      document.getElementById('addKpiEntries').disabled = false;
    }
  }

  // Event handlers for modal buttons
  document.addEventListener('DOMContentLoaded', function() {
    // Save button click handler
    document.getElementById('saveBtn').addEventListener('click', function() {
      // Close the edit modal
      bootstrap.Modal.getInstance(document.getElementById('editUserModal')).hide();

      // Show success modal
      const successModal = new bootstrap.Modal(document.getElementById('successModal'));
      successModal.show();

      // Here you would normally save the data to your backend
      // saveUserData(formData);
    });

    // Reset button click handler
    document.getElementById('resetBtn').addEventListener('click', function() {
      document.getElementById('editUserForm').reset();
    });
  });

   // Initialize column display preferences
    document.addEventListener('DOMContentLoaded', function() {
      // Load saved preferences if they exist
      const savedPreferences = localStorage.getItem('tableColumnPreferences');
      if (savedPreferences) {
        const preferences = JSON.parse(savedPreferences);
        
        // Apply saved preferences to checkboxes
        document.querySelectorAll('.column-toggle').forEach(checkbox => {
          const column = checkbox.getAttribute('data-column');
          if (preferences[column] !== undefined) {
            checkbox.checked = preferences[column];
            toggleColumnVisibility(column, preferences[column]);
          }
        });
      }
      
      // Apply column settings when button is clicked
      document.getElementById('applyColumnSettings').addEventListener('click', function() {
        const preferences = {};
        
        document.querySelectorAll('.column-toggle').forEach(checkbox => {
          const column = checkbox.getAttribute('data-column');
          preferences[column] = checkbox.checked;
          toggleColumnVisibility(column, checkbox.checked);
        });
        
        // Save preferences to local storage
        localStorage.setItem('tableColumnPreferences', JSON.stringify(preferences));
      });
    });
    
    // Toggle column visibility
    function toggleColumnVisibility(column, visible) {
      const table = document.getElementById('userTable');
      const thIndex = Array.from(table.querySelectorAll('th')).findIndex(th => th.getAttribute('data-column') === column);
      
      if (thIndex !== -1) {
        // Toggle header visibility
        const th = table.querySelector(`th[data-column="${column}"]`);
        if (visible) {
          th.classList.remove('hidden-column');
        } else {
          th.classList.add('hidden-column');
        }
        
        // Toggle cell visibility in each row
        table.querySelectorAll('tbody tr').forEach(row => {
          const cell = row.cells[thIndex];
          if (visible) {
            cell.classList.remove('hidden-column');
          } else {
            cell.classList.add('hidden-column');
          }
        });
      }
    }
    
</script>