@extends('layouts/contentNavbarLayout')

@section('title', 'User Access Configuration')

@section('content')
@php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'KPI Administration'],
    ['label' => 'User Access Configuration']
  ];
@endphp

@include('layouts.partials.page-header', [
  'title' => 'User Access Configuration',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))->render()
])

<br>

<div class="card">
  <div class="card-body p-0">
    <!-- Tabs -->
    <ul class="nav nav-tabs" role="tablist">
      <li class="nav-item">
        <!-- <button class="nav-link active" id="user-access-tab" data-bs-toggle="tab" data-bs-target="#user-access" type="button" role="tab" aria-controls="user-access" aria-selected="true">User Access</button> -->
      </li>
      <li class="nav-item">
        <!-- <button class="nav-link" id="roles-tab" data-bs-toggle="tab" data-bs-target="#roles" type="button" role="tab" aria-controls="roles" aria-selected="false">Roles</button> -->
      </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content">
      <!-- User Access Tab -->
      <div class="tab-pane fade show active p-3" id="user-access" role="tabpanel" aria-labelledby="user-access-tab">
        <div class="mb-4">
        <h5 class="mb-3 text-primary fw-bold">User Access List</h5>
        <!-- <hr class="mt-0 mb-3" style="border-top: 0.1px solid #ddd;"> -->
          
          @include('content.kpiAdmin.partials.user-access.filters')<br>
          @include('content.kpiAdmin.partials.user-access.table-controls')
          @include('content.kpiAdmin.partials.user-access.data-table')
          @include('content.kpiAdmin.partials.user-access.pagination')
        </div>
      </div>

      <!-- Roles Tab -->
<div class="tab-pane fade p-3" id="roles" role="tabpanel" aria-labelledby="roles-tab">
  @include('content.kpiAdmin.partials.roles.role-selector')

  {{-- Role Descriptions --}}
  <div id="desc-pmuAdmin" class="role-desc mb-4">
  </div>
  <div id="desc-itAdmin" class="role-desc mb-4">
  </div>
  <div id="desc-auditor" class="role-desc mb-4" >
  </div>
  <div id="desc-matradeEmployee" class="role-desc mb-4">
  </div>

  {{-- Module injection targets --}}
<div id="module-kpiAdmin" class="module-block mb-4"></div>
<div id="module-kpiAchievement" class="module-block mb-4"></div>
<div id="module-kpiDashboard" class="module-block mb-4"></div>
<div id="module-kpiReporting" class="module-block mb-4"></div>
<div id="module-kpiIndicator" class="module-block mb-4"></div>


  {{-- Modules --}}
  {{-- Hidden partials untuk isi ke module-block --}}
<div id="partial-kpiAdmin">
  @include('content.kpiAdmin.partials.roles.kpi-admin-permissions')
</div>

<div id="partial-kpiAchievement">
  @include('content.kpiAdmin.partials.roles.kpi-achievement-permissions')
</div>

<div id="partial-kpiDashboard">
  @include('content.kpiAdmin.partials.roles.kpi-dashboard-permissions')
</div>

<div id="partial-kpiReporting">
  @include('content.kpiAdmin.partials.roles.kpi-reporting-permissions')
</div>



  </div>
</div>


@include('content.kpiAdmin.partials.modals.success-modal')
@include('content.kpiAdmin.js.kpi-admin-access')
@endsection

@push('scripts')
<script>
  const roleAccessMap = {
    pmuAdmin: ['kpiAdmin', 'kpiAchievement', 'kpiDashboard', 'kpiReporting', 'kpiIndicator'],
    itAdmin: ['kpiAdmin', 'kpiIndicator', 'kpiReporting'],
    editor: ['kpiAdmin', 'kpiAchievement', 'kpiDashboard', 'kpiIndicator', 'kpiReporting'],
    matradeEmployee: ['kpiIndicator', 'kpiAchievement', 'kpiDashboard', 'kpiReporting'],
    auditor: ['kpiIndicator', 'kpiAchievement', 'kpiDashboard', 'kpiReporting']
  };

  document.addEventListener('DOMContentLoaded', function () {
    updatePermissions();

    const roleDropdown = document.getElementById('userRole');
    if (roleDropdown) {
      roleDropdown.addEventListener('change', updatePermissions);
    }
  });

  function updatePermissions() {
    const role = document.getElementById('userRole')?.value;

    // Hide all descriptions
    document.querySelectorAll('.role-desc').forEach(e => e.style.display = 'none');

    // Show relevant description
    const descBlock = document.getElementById('desc-' + role);
    if (descBlock) descBlock.style.display = 'block';

    // Clear all module containers
    document.querySelectorAll('.module-block').forEach(e => e.innerHTML = '');

    // Load allowed modules
    if (roleAccessMap[role]) {
      roleAccessMap[role].forEach(module => {
        const target = document.getElementById('module-' + module);
        const partial = document.getElementById('partial-' + module);
        if (target && partial) {
          target.innerHTML = partial.innerHTML;
        }
      });
    }
  }
</script>
@endpush
