@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Indicator - New')

@section('content')

<style>
  /* Padding dan border antara cells */
  table.table td, table.table th {
    padding: 0.75rem 1rem;
    vertical-align: middle;
    border: 1px solid #dee2e6;
  }
  
  /* Hover row */
  table.table-hover tbody tr:hover {
    background-color: #f8f9fa;
  }
  
  /* Bucu bulat untuk table */
  .table-responsive > .table {
    border-radius: 0.75rem;
    overflow: hidden;
  }
</style>

<link href="https://cdn.jsdelivr.net/npm/tom-select/dist/css/tom-select.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://unpkg.com/feather-icons"></script>
<script src="https://cdn.jsdelivr.net/npm/tom-select/dist/js/tom-select.complete.min.js"></script>
<script src="{{ asset('js/kpiIndicator.js') }}"></script>
 @php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'KPI Indicator'],
    ['label' => 'Create New Indicator']
  ];
@endphp

@include('layouts.partials.page-header', [
  'title' => 'Create New Indicator',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))->render()
])
      <br>
      <div class="row">
        <div class="col-12 d-flex justify-content-between align-items-center">
          <h4 class="fw-bold py-2 mb-3"></h4>
          <button type="button" class="btn btn-primary " data-bs-toggle="modal" data-bs-target="#addNewModal">
              Add New
            </button>
        </div>
      </div>
      <br>

        <!-- Butang Add New -->
          <!-- Letak text-end untuk align kanan -->
          <!-- <div class="text-end">
            <button type="button" class="btn btn-primary " data-bs-toggle="modal" data-bs-target="#addNewModal">
              Add New
            </button>
          </div>
          <br> -->

    <script src="https://unpkg.com/feather-icons"></script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    

    <div class="card">
      <!-- Card Body -->
      <div class="card-body">

      <div class="d-flex flex-column gap-2 mb-3">
      
          <!-- Previous Year Indicator List -->  
          @include('newIndicator.previous-indicator-list')

          <!-- Next Year Indicator List -->
          @include('newIndicator.next-indicator-list')

      </div>
    </div>
</div>

<script>
  // new TomSelect("#division", {
  //   plugins: ['remove_button'],
  //   maxItems: null,
  //   create: false
  // });

  // new TomSelect("#section", {
  //   plugins: ['remove_button'],
  //   maxItems: null,
  //   create: false
  // });

  // new TomSelect("#unit", {
  //   plugins: ['remove_button'],
  //   maxItems: null,
  //   create: false
  // });

  $(document).ready(function () {
    // Initialize DataTable
    $('#indicatorTable').DataTable();

    // Feather Icons
    feather.replace();

    // // Toggle button functionality
    // $('#toggleTableBtn').on('click', function () {
    //   console.log('Toggle button clicked'); // Debugging line
    //   $('#tableContainer').slideToggle(); // Smooth show/hide animation
    // });
  });
</script>

<script>
  // $(document).ready(function() {
  //   // Simple toggle test
  //   $('#toggleTableBtn').click(function() {
  //     $('#tableContainer').slideToggle();
  //   });
  // });
</script>

<script>
    // function handleSelect(selectElement) {
    //     const selectedValue = selectElement.value;
    //     if (selectedValue) {
    //         alert("You selected: " + selectedValue.charAt(0).toUpperCase() + selectedValue.slice(1));
    //     }
    // }

    public function index(Request $request)
{
    $perPage = $request->input('perPage', 10); // default to 10

    $query = YourModel::query();

    if ($perPage === 'all') {
        $items = $query->get(); // show all
    } else {
        $items = $query->paginate((int)$perPage)->appends($request->query());
    }

    return view('your-view-name', compact('items'));
}

</script>

<script>
  $(document).ready(function () {
    $('#toggleCommonBtn').on('click', function () {
      $('#tableCommon').slideToggle(); // Animasi toggle buka/tutup

      // Tukar icon arah bila buka/tutup
      $(this).find('i').toggleClass('bx-chevron-right bx-chevron-down');
    });
  });
</script>

<script>
  document.getElementById('confirmCopyBtn').addEventListener('click', function () {
    // Close modal
    const modal = bootstrap.Modal.getInstance(document.getElementById('copyConfirmModal'));
    modal.hide();

    // Show toast
    const toast = new bootstrap.Toast(document.getElementById('copyToast'));
    toast.show();


    // Optionally do your copy logic here (e.g., copy to clipboard, or server action)
    // For example:
    // navigator.clipboard.writeText('Your message here');
  });

  document.getElementById('confirmCopyBtn').addEventListener('click', function () {
  // Tutup confirmation modal
  const confirmModal = bootstrap.Modal.getInstance(document.getElementById('copyConfirmModal'));
  confirmModal.hide();

  // Selepas modal tutup, buka success modal
  setTimeout(function () {
    const successModal = new bootstrap.Modal(document.getElementById('copySuccessModal'));
    successModal.show();
  }, 300); // Tunggu sekejap supaya modal sebelum ni betul² tertutup

  // Bila copy gagal
  function showCopyError() {
    const errorModal = new bootstrap.Modal(document.getElementById('copyErrorModal'));
    errorModal.show();
  }

});

document.getElementById('confirmCopyBtn').addEventListener('click', function () {
  const confirmModal = bootstrap.Modal.getInstance(document.getElementById('copyConfirmModal'));
  confirmModal.hide();

  // Simulasi: jika gagal copy
  const copySuccess = false; // <-- tukar ikut logik sebenar anda

  setTimeout(function () {
    if (copySuccess) {
      const successModal = new bootstrap.Modal(document.getElementById('copySuccessModal'));
      successModal.show();
    } else {
      const errorModal = new bootstrap.Modal(document.getElementById('copyErrorModal'));
      errorModal.show();
    }
  }, 300);
});

</script>

<script>
  document.getElementById('successOkBtn').addEventListener('click', function () {
    window.location.href = "{{ url()->current() }}"; // Guna semula page asal
  });

  document.getElementById('errorOkBtn').addEventListener('click', function () {
    window.location.href = "{{ url()->current() }}"; // Sama juga
  });
</script>

<script>
  let currentCopyType = null;

  // Bila butang Copy ditekan
  function showCopyConfirm(copyType) {
    console.log("Copy type:", copyType); // Debug log
    currentCopyType = copyType;

    const confirmModal = new bootstrap.Modal(document.getElementById('copyConfirmModal'));
    confirmModal.show();
  }

  // Bila tekan "Yes" dalam modal confirm
  document.addEventListener('DOMContentLoaded', function () {
    const confirmBtn = document.getElementById('confirmCopyBtn');
    const successModalEl = document.getElementById('copySuccessModal');
    const errorModalEl = document.getElementById('copyErrorModal');

    confirmBtn.addEventListener('click', function () {
      const confirmModal = bootstrap.Modal.getInstance(document.getElementById('copyConfirmModal'));
      confirmModal.hide();

      setTimeout(() => {
        if (currentCopyType === 'copyType2') {
          const errorModal = new bootstrap.Modal(errorModalEl);
          errorModal.show();
        } else {
          const successModal = new bootstrap.Modal(successModalEl);
          successModal.show();
        }
      }, 500);
    });

    document.getElementById('successOkBtn').addEventListener('click', () => {
      // reload balik atau tutup modal je pun boleh
      location.reload(); 
    });

    document.getElementById('errorOkBtn').addEventListener('click', () => {
      location.reload();
    });
  });
</script>

<script>
  document.getElementById('confirmUpdateBtn').addEventListener('click', function () {
    // Tutup modal confirmation
    const confirmModal = new bootstrap.Modal(document.getElementById('confirmUpdateModal'));
    confirmModal.hide();

    // Proses simpan data (contohnya, dengan AJAX atau submit borang)
    document.getElementById('updateForm').submit(); // Hantar borang jika sudah confirm

    // Optional: Show confirmation notification (contohnya Toast)
    //alert('Maklumat telah dikemaskini!');
  });
</script>

<script>
  document.getElementById('backButton').addEventListener('click', function () {
    location.reload(); // Ini akan memuat semula halaman yang sama
  });

  $(document).ready(function () {
  $('#addNewBtn').on('click', function () {
    // Toggle form visibility ketika Add New di klik
    $('#newIndicatorForm').toggle();
  });
});

// document.getElementById("toggleTableBtn").addEventListener("click", function () {
//     var wrapper = document.getElementById("indicatorTableWrapper");
//     var icon = this.querySelector("i");

//     if (wrapper.style.display === "none") {
//       wrapper.style.display = "block";
//       icon.classList.remove("bx-chevron-right");
//       icon.classList.add("bx-chevron-down");
//     } else {
//       wrapper.style.display = "none";
//       icon.classList.remove("bx-chevron-down");
//       icon.classList.add("bx-chevron-right");
//     }
//   });

</script>

@endsection
