<!-- Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editModalLabel">Edit Indicator</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        <form id="updateForm" method="POST" action="{{ route('indicators.update') }}">
          {!! csrf_field() !!}  
          <input type="hidden" id="indicator_id" name="indicator_id_e">
          <input type="hidden" id="kpi_achievement_id" name="kpi_achievement_id_e">

          <input type="hidden" id="division" name="division_e">
          <input type="hidden" id="section" name="section_e">
          <input type="hidden" id="unit" name="unit_e">
          
          <div class="row">
            <!-- Row 1: Year -->
            <div class="row mb-3 align-items-center">
              <label class="col-md-3 col-form-label">Year</label>
              <div class="col-md-9">
                <input type="text" class="form-control" name="year_e">
              </div>
            </div>

            <!-- Row 2: Indicator -->
            <div class="row mb-3 align-items-center">
              <label class="col-md-3 col-form-label">Indicator</label>
              <div class="col-md-9">
                <input type="text" class="form-control" name="indicator_e" value="Payment to supplier">
              </div>
            </div>

            <div class="mb-3 row">
              <label for="indicator_type" class="col-sm-3 col-form-label">Indicator Type</label>
              <div class="col-sm-9">
                <select class="form-select" id="kpi_indicator_type_id" name="kpi_indicator_type_id_e">
                  <option value="" disabled>Select Indicator Type</option>
                  @foreach ($indicator_type_list as $item)
                        <option value="{{ $item->kpi_indicator_type_id }}" 
                          data-definition_e="{{ $item->indicator_type_description }}">
                            {{ formatType($item->indicator_type) }}</option>
                    @endforeach
                </select>
              </div>
            </div>

            <!-- Textarea for Indicator Type Definition -->
            <div class="row mb-3">
              <label class="col-md-3 col-form-label">Indicator Type Definition</label>
              <div class="col-md-9">
                <textarea class="form-control" id="indicator_type_def_e" name="indicator_type_def_e" rows="3" readonly></textarea>
              </div>
            </div>

            <!-- Row 4: Submission -->
            <div class="row mb-3 align-items-center">
              <label for="submission" class="col-md-3 col-form-label">Submission</label>
              <div class="col-md-9">
                <select class="form-select" id="submission" name="submission_e">
                  <option value="">-- Please Select --</option>
                  <option value="anually">Anually</option>
                  <option value="quarter" selected>Quarterly</option>
                  <option value="bi_anually">Bi Anually</option>
                </select>
              </div>
            </div>

            <!-- Row 5: Annual Target -->
            <div class="row mb-3 align-items-center">
              <label class="col-md-3 col-form-label">Annual Target</label>
              <div class="col-md-9">
                <input type="text" class="form-control" name="annual_target_e" value="100">
              </div>
            </div>

            <!-- Row 6: Metric -->
            <div class="row mb-3 align-items-center">
              <label for="metric" class="col-sm-3 col-form-label">Metric</label>
              <div class="col-sm-9">
                <select class="form-select" id="metric" name="metric_e">
                  <option value=""> Please Select </option>
                  <option value="activity">Activity</option>
                  <option value="article">Article</option>
                  <option value="booklet">Booklet</option>
                  <option value="company">Company</option>
                  <option value="enquiry">Enquiry</option>
                  <option value="event">Event</option>
                  <option value="exam">Exam</option>
                  <option value="followers">Followers</option>
                  <option value="media_coverage">Media Coverage</option>
                  <option value="meeting">Meeting</option>
                  <option value="percentage" selected>Percentage</option>
                  <option value="phase">Phase</option>
                  <option value="press_releases">Press Releases</option>
                  <option value="profiles">Profiles</option>
                  <option value="programme">Programme</option>
                  <option value="publication">Publication</option>
                  <option value="release">Release</option>
                  <option value="report">Report</option>
                  <option value="rm">RM</option>
                  <option value="story">Story</option>
                  <option value="time">Time</option>
                  <option value="unit">Unit</option>
                  <option value="update">Update</option>
                </select>
              </div>
            </div>


            <!-- Row 7: Category -->
            <div class="row mb-3 align-items-center">
              <label for="category" class="col-md-3 col-form-label">Category</label>
              <div class="col-md-9">
                <select class="form-select" id="category" name="category_e">
                  <option value="">-- Please Select --</option>
                  <option value="customer">Customer</option>
                  <option value="finance">Finance</option>
                  <option value="people">People</option>
                  <option value="process">Process</option>
                </select>
              </div>
            </div>

            <!-- Row 8: Output/Outcome -->
            <div class="row mb-3 align-items-center">
              <label for="output_outcome" class="col-md-3 col-form-label">Output/Outcome</label>
              <div class="col-md-9">
                <select class="form-select" id="output_outcome" name="output_outcome_e">
                  <option value="">-- Please Select --</option>
                  <option value="output" selected>Output</option>
                  <option value="outcome">Outcome</option>
                  <option value="process">Process</option>
                </select>
              </div>
            </div>

            <!-- Row 9: Component Achievement -->
            <div class="row mb-3 align-items-center">
              <label for="component_achievement" class="col-md-3 col-form-label">Component Achievement</label>
              <div class="col-md-9">
                <select class="form-select" id="component_achievement" name="component_achievement_e">
                  <option value="">-- Please Select --</option>
                  <option value="promotion">Export Promotion</option>
                  <option value="development">Exporters Development</option>
                  <option value="na" selected>N/A</option>
                </select>
              </div>
            </div>

          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#confirmUpdateModal">
          Save
        </button>
      </div>
    </div>
  </div>
</div>
<!-- Confirmation Modal -->
<div class="modal fade" id="confirmUpdateModal" tabindex="-1" aria-labelledby="confirmUpdateModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="confirmUpdateModalLabel">Confirm Update</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        <p>Are you sure you want to update the information?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" id="confirmUpdateBtn">Yes, Update</button>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const editModal = document.getElementById('editModal');

    editModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        if (!button) return;

        // Loop over all attributes of button that start with data-
        Array.from(button.attributes).forEach(attr => {
            if (attr.name.startsWith("data-")) {
                // Remove "data-" prefix
                const fieldName = attr.name.replace("data-", "");
                const input = editModal.querySelector(`[name="${fieldName}_e"], [name="${fieldName}_old"]`);
                if (input) input.value = attr.value;
            }
        });

        const selectedTypeId = button.getAttribute('data-kpi_indicator_type_id');
        const typeSelect = editModal.querySelector('#kpi_indicator_type_id');
        const typeDefTextarea = document.getElementById('indicator_type_def_e');
        if (typeSelect && selectedTypeId) {
            typeSelect.value = selectedTypeId;
            const selectedOption = typeSelect.querySelector(`option[value="${selectedTypeId}"]`);
            if (selectedOption) {
                document.getElementById('indicator_type_def_e').value = selectedOption.getAttribute('data-definition_e') || '';
            }
        }

        typeSelect.addEventListener('change', function () {
          const selectedOption = typeSelect.options[typeSelect.selectedIndex];
          typeDefTextarea.value = selectedOption.getAttribute('data-definition_e') || '';
        });

    });

    // // Submit form on confirm update
    // document.getElementById('confirmUpdateBtn').addEventListener('click', function () {
    //     document.getElementById('updateForm').submit();
    // });
});
</script>
