<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Jkkp6;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $user = backpack_auth()->user();

        if (!$user) {
            abort(403, 'Unauthenticated.');
        }

        $role = strtolower($user->user_role);
        $allowedStatuses = [];

        switch ($role) {
            case 'pj':
                $allowedStatuses = ['Baharu', 'Dalam Proses', 'Disemak', 'Lulus Semakan', 'Kes Tutup'];
                break;
            case 'kkp':
                $allowedStatuses = ['Dalam Proses', 'Disemak', 'Lulus Semakan', 'Kes Tutup'];
                break;
            case 'ins':
                $allowedStatuses = ['Dalam Proses', 'Disemak'];
                break;
            case 'kjsk':
                $allowedStatuses = ['Dalam Proses', 'Disemak', 'Lulus Semakan', 'Kes Tutup'];
                break;
            case 'pkp':
                $allowedStatuses = ['Dalam Proses', 'Lulus Semakan', 'Kes Tutup'];
                break;
            case 'kj':
                $allowedStatuses = ['Dalam Proses', 'Lulus Semakan', 'Kes Tutup'];
                break;
            default:
                $allowedStatuses = [];
        }

        $query = Jkkp6::query()
            ->whereIn('status', $allowedStatuses)
            ->latest('created_date');

        if ($request->filled('search')) {
            $query->where(function ($q) use ($request) {
                $q->where('maklumat_pekerja', 'like', "%{$request->search}%")
                  ->orWhere('maklumat_nama', 'like', "%{$request->search}%");
            });
        }

        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        $jkkpItems = $query->paginate($request->per_page ?? 10)->appends($request->query());

        $baseQuery = Jkkp6::whereIn('status', $allowedStatuses);

        $total = $baseQuery->count();
        $selesai = (clone $baseQuery)->where('status', 'Kes Tutup')->count();
        $belum = $total - $selesai;

        return view('dashboard.index', compact('jkkpItems', 'role', 'allowedStatuses', 'selesai', 'belum', 'total'));
    }
}
