<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
      public function up()
    {
        Schema::dropIfExists('jkkp6'); // Optional: if you want to recreate the table
        
        Schema::create('jkkp6', function (Blueprint $table) {
            $table->id('id_jkkp6');
            $table->uuid('ulid_jkkp6')->unique();
            $table->text('maklumat_pekerja')->nullable();
            $table->string('maklumat_jabatan')->nullable();
            $table->string('maklumat_nama')->nullable();
            $table->string('maklumat_jawatan_2')->nullable();
            $table->string('maklumat_notelefon')->nullable();
            $table->text('orang_terlibat')->nullable();
            $table->string('orang_terlibat_kj')->nullable();
            $table->date('tarikh_kemalangan')->nullable();
            $table->time('masa_kemalangan')->nullable();
            $table->text('tempat_kemalangan')->nullable();
            $table->text('huraian_kemalangan')->nullable();
            $table->text('selepas_kemalangan')->nullable();
            $table->string('status')->nullable();
            $table->timestamp('created_date')->nullable();
            $table->timestamp('updated_date')->nullable();
            $table->timestamp('deleted_date')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
