@extends(backpack_view('blank'))

@php
    use Carbon\Carbon;

    $statusColors = [
        'Dalam Proses' => 'bg-purple',
        'Baharu' => 'bg-info',
        'Disemak' => 'bg-pink',
        'Lulus Semakan' => 'bg-yellow',
        'Kes Tutup' => 'bg-blue',
    ];

    $perPage = request('per_page', 10);
    $search = request('search');
    $statusFilter = request('status');

    $query = \App\Models\Jkkp6::query()->latest('created_date');

    if ($search) {
        $query->where(function($q) use ($search) {
            $q->where('maklumat_pekerja', 'like', "%$search%")
              ->orWhere('maklumat_nama', 'like', "%$search%");
        });
    }

    if ($statusFilter) {
        $query->where('status', $statusFilter);
    }

    $jkkpItems = $query->paginate($perPage)->appends(request()->query());
@endphp

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold mb-3 heading-24"> JKKP 6 - PEMBERITAHUAN MENGENAI KEMALANGAN/KEJADIAN BERBAHAYA</h4>

        <a href="javascript:void(0);" 
           class="btn rounded-pill text-white disabled" 
           style="background-color: #487FFF; border-color: #487FFF; pointer-events: none; opacity: 0.6;">
            + Aduan Baharu
        </a>
    </div>

    <div class="card p-4 shadow-sm border-0 rounded-4">
        <h5 class="fw-semibold mb-3 heading-18">Senarai Pekerja</h5>

        <form method="GET" id="filter-form">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    Show
                    <select name="per_page" class="form-select d-inline-block w-auto mx-1" onchange="this.form.submit()">
                        <option value="10" {{ request('per_page') == 10 ? 'selected' : '' }}>10</option>
                        <option value="25" {{ request('per_page') == 25 ? 'selected' : '' }}>25</option>
                        <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50</option>
                    </select>
                    entries
                </div>

                <div class="d-flex gap-2">
                    <select name="status" class="form-select w-auto" onchange="this.form.submit()">
                        <option value="">All Status</option>
                        @foreach(array_keys($statusColors) as $statusOption)
                            <option value="{{ $statusOption }}" {{ request('status') == $statusOption ? 'selected' : '' }}>
                                {{ $statusOption }}
                            </option>
                        @endforeach
                    </select>

                    <input type="search" name="search" class="form-control" placeholder="Search"
                           value="{{ request('search') }}"
                           onkeydown="if(event.key === 'Enter') this.form.submit();">
                </div>
            </div>
        </form>

        <table class="table table-hover align-middle">
            <thead>
                <tr>
                    <th><input type="checkbox" id="check-all" onclick="toggleCheckboxes(this)"></th>
                    <th>S.L</th>
                    <th>No. Pekerja</th>
                    <th>Nama</th>
                    <th>Created Date</th>
                    <th>Updated Date</th>
                    <th>Status</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                @forelse($jkkpItems as $i => $item)
                    @php
                        $status = $item->status ?? 'Baharu';
                        $badgeClass = $statusColors[$status] ?? 'bg-secondary';
                    @endphp
                    <tr>
                        <td><input type="checkbox" class="row-checkbox"></td>
                        <td>{{ $loop->iteration + ($jkkpItems->currentPage() - 1) * $jkkpItems->perPage() }}</td>
                        <td><a href="#" class="text-decoration-none fw-semibold text-primary">{{ $item->maklumat_pekerja }}</a></td>
                        <td>{{ $item->maklumat_nama }}</td>
                        <td>{{ Carbon::parse($item->created_date)->format('d M Y') }}</td>
                        <td>{{ Carbon::parse($item->updated_date)->format('d M Y') }}</td>
                        <td><span class="badge {{ $badgeClass }}">{{ $status }}</span></td>
                        <td class="d-flex gap-2 justify-content-center">
                            <a href="{{ backpack_url('jkkp6/' . $item->id_jkkp6 . '/show') }}" class="btn btn-sm btn-outline-primary rounded-circle" title="Lihat">
                                <i class="la la-eye"></i>
                            </a>
                            <a href="{{ backpack_url('jkkp6/' . $item->id_jkkp6 . '/edit') }}" class="btn btn-sm btn-outline-success rounded-circle" title="Kemaskini">
                                <i class="la la-edit"></i>
                            </a>
                            <form method="POST" action="{{ backpack_url('jkkp6/' . $item->id_jkkp6) }}" onsubmit="return confirm('Padam rekod ini?');">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-outline-danger rounded-circle" title="Padam">
                                    <i class="la la-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="8" class="text-center">Tiada rekod dijumpai.</td></tr>
                @endforelse
            </tbody>
        </table>

        <div class="d-flex justify-content-end mt-3">
            {!! $jkkpItems->links() !!}
        </div>
    </div>
@endsection

@push('after_styles')
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
@endpush

@push('after_scripts')
<script>
    function toggleCheckboxes(source) {
        let checkboxes = document.querySelectorAll('.row-checkbox');
        checkboxes.forEach(cb => cb.checked = source.checked);
    }
</script>
@endpush
