<?php

namespace App\Http\Controllers\authentications;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class LoginController extends Controller
{
    // Show login page
    public function showLoginForm()
    {
        if (Auth::check()) {
            return redirect()->route('dashboard-analytics');
        }

        return view('content.authentications.login');
    }

    // Handle login POST
 public function login(Request $request)
{
    $request->validate([
        'name' => 'required|string|max:255',
        'password' => 'required|string',
    ]);

    $user = User::where('u_email', $request->name)->first();
    if ($user && Hash::check($request->password, $user->password)) {
        Auth::login($user);
        //dd(Auth::check(), Auth::user(), url()->previous());
        //$request->session()->regenerate();
        return redirect()->route('dashboard-analytics')->with('success', 'Welcome back, ' . $user->u_name . '!');
    }

    return back()->withErrors(['Invalid username or password.']);
}



    // Handle logout
public function logout(Request $request)
    {
        Auth::logout();
        return redirect()->route('login');
    }
}
