<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Indicator\IndicatorService;

class AccountSettingsAccount extends Controller
{
  private function indicatorService()
  {
    return new IndicatorService();
  }

  public function index(Request $request)
  { 
    $indicator_type_list = $this->indicatorService()->getIndicatorTypeList(); 
    $submitted_indicator_list = $this->indicatorService()->getIndicatorList($request);
    return view('content.pages.pages-account-settings-account', 
                compact('submitted_indicator_list', 'indicator_type_list'));
  }

  public function SubmitIndicator(Request $request)
  {
    $result = $this->indicatorService()->storeSubmitIndicatorFromIndicatorList($request);
    return redirect()->route('pages-account-settings-account')->with('success', 'Indicator submitted successfully!');
  }

}
