<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Indicator\IndicatorService;

class PMUIndicator extends Controller
{
  private function indicatorService()
  {
    return new IndicatorService();
  }

  public function index(Request $request)
  { 
    $indicator_type_list = $this->indicatorService()->getIndicatorTypeList();
    $submitted_indicator_list = $this->indicatorService()->getSubmittedIndicatorList($request);
    return view('content.pages.kpi-indicator-pmu-admin', compact(
      'indicator_type_list',
      'submitted_indicator_list'
    ));
  }

  public function endorseIndicator(Request $request)
  {
    $result = $this->indicatorService()->endorseIndicator($request);
    return redirect()->route('kpi-indicator-pmu-admin')->with('success', 'Selected indicators have been endorsed successfully.');
  }

  public function disableIndicator(Request $request)
  { 
    $result = $this->indicatorService()->disableIndicator($request);
    return redirect()->route('kpi-indicator-pmu-admin')->with('success', 'Selected indicator has been disabled successfully.');
  }
}
