<?php
namespace App\Services\KpiAchievement;
use Illuminate\Http\Request;

use DB;

class EmployeeKpiAchievementService
{
    function getKpiAchievements(Request $request)
    {
        $status = 'draft';

        $query = DB::table('kpi_indicator as ki')
                ->join('kpi_achievement AS ka', 'ki.kpi_achievement_id', '=', 'ka.kpi_achievement_id')
                ->join('kpi_indicator_type AS kit', 'ki.kpi_indicator_type_id', '=', 'kit.kpi_indicator_type_id')
                ->select(
                    'ki.Indicator_id AS indicator_id',
                    'ki.Year AS year',
                    'ki.Division AS division',
                    'ki.Section AS section',
                    'ka.unit',
                    'ki.Indicator AS indicator',
                    'ka.indicator_Description AS description',
                    'ki.Submission AS submission',
                    'ka.annual_target',
                    'ki.Metric AS metric',
                    'ki.Category AS category',
                    'ki.Output_Outcome AS output_outcome',
                    'kit.indicator_type AS indicator_type',
                    'kit.indicator_type_description AS indicator_type_def',
                    'ki.Component_Achievement AS component_achv',
                    'ki.Status AS status',
                    'ka.kpi_achievement_id AS kpi_achievement_id',
                    'kit.kpi_indicator_type_id AS kpi_indicator_type_id'
                );
        if($request->year) {
            $query->where('ki.Year', $request->year);
        }

        if($request->division) {
            $query->where('ki.Division', $request->division);
        }

        if($request->section) {
            $query->where('ki.Section', $request->section);
        }
        
        if($request->section) {
            $query->where('ki.Section', $request->section);
        }

        if($request->unit) {
            $query->where('ka.unit', $request->unit);
        }

        if($request->indicator_type) {
            $query->where('ki.kpi_indicator_type_id', $request->indicator_type);
        }

        if($request->status) {
            $query->where('ki.Status', $request->status);
        }

        if($request->indicator) {
            $query->where('ki.Indicator', $request->indicator);
        }
        if($request->achievement && $request->achievement!='')
        {
            $query->where('ka.cumulative_achievement',$request->achievement);
        }

        $result = $query->get();
        return $result;
    }

    public function getAchievementList($request)
    {

        //$status = 'submitted';

        $query = DB::table('kpi_indicator as ki')
                ->join('kpi_achievement AS ka', 'ki.kpi_achievement_id', '=', 'ka.kpi_achievement_id')
                ->join('kpi_indicator_type AS kit', 'ki.kpi_indicator_type_id', '=', 'kit.kpi_indicator_type_id')
                ->select(
                    'ki.Indicator_id AS indicator_id',
                    'ki.Year AS year',
                    'ki.Division AS division',
                    'ki.Section AS section',
                    'ka.unit',
                    'ki.Indicator AS indicator',
                    'ka.indicator_Description AS description',
                    'ki.Submission AS submission',
                    'ka.annual_target',
                    'ki.Metric AS metric',
                    'ki.Category AS category',
                    'ki.Output_Outcome AS output_outcome',
                    'kit.indicator_type AS indicator_type',
                    'kit.indicator_type_description AS indicator_type_def',
                    'ki.Component_Achievement AS component_achv',
                    'ki.Status AS status',
                    'ka.kpi_achievement_id AS kpi_achievement_id',
                    'kit.kpi_indicator_type_id AS kpi_indicator_type_id',
                    'ka.PMU_activity_remark AS pmu_remarks'
                );
                //->where('ki.Status', $status);

        if($request->year) {
            $query->where('ki.Year', $request->year);
        }

        if($request->division) {
            $query->where('ki.Division', $request->division);
        }

        if($request->section) {
            $query->where('ki.Section', $request->section);
        }
        
        if($request->section) {
            $query->where('ki.Section', $request->section);
        }

        if($request->unit) {
            $query->where('ka.unit', $request->unit);
        }

        if($request->indicator_type) {
            $query->where('ki.kpi_indicator_type_id', $request->indicator_type);
        }

        if($request->status) {
            $query->where('ki.Status', $request->status);
        }

        if($request->indicator) {
            $query->where('ki.Indicator', $request->indicator);
        }

        if ($request->achievement) {
            $query->where('achievement', 'like', '%' . $request->achievement . '%');
        }

        $result = $query->get();
        return $result;
    }

    public function getAchievementTypeList()
    {
        $result = DB::table('kpi_indicator_type')
                ->select('*')
                ->get();
        return $result;
    }
}
