<?php

$spBaseUrl = 'https://kmstg.matrade.gov.my/sso';

$settings = array (
    // If 'strict' is True, then the PHP Toolkit will reject unsigned
    // or unencrypted messages if it expects them signed or encrypted
    // Also will reject the messages if not strictly follow the SAML
    // standard: Destination, NameId, Conditions ... are validated too.
    'strict' => true,

    // Enable debug mode (to print errors)
    'debug' => false,

    // Set a BaseURL to be used instead of try to guess
    // the BaseURL of the view that process the SAML Message.
    // Ex. http://sp.example.com/
    //     http://example.com/sp/
    'baseurl' => null,

    // Service Provider Data that we are deploying
    'sp' => array (
        // Identifier of the SP entity  (must be a URI)
        'entityId' => $spBaseUrl.'/metadata.php',
        // Specifies info about where and how the <AuthnResponse> message MUST be
        // returned to the requester, in this case our SP.
        'assertionConsumerService' => array (
            // URL Location where the <Response> from the IdP will be returned
            'url' => $spBaseUrl.'/acs.php',
            // SAML protocol binding to be used when returning the <Response>
            // message.  Onelogin Toolkit supports for this endpoint the
            // HTTP-POST binding only
            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
        ),
        // If you need to specify requested attributes, set a
        // attributeConsumingService. nameFormat, attributeValue and
        // friendlyName can be omitted. Otherwise remove this section.
        //"attributeConsumingService"=> array(
        //        "serviceName" => "SP test",
        //        "serviceDescription" => "Test Service",
        //        "requestedAttributes" => array(
        //            array(
        //                "name" => "",
        //                "isRequired" => false,
        //                "nameFormat" => "",
        //                "friendlyName" => "",
        //                "attributeValue" => ""
        //            )
        //        )
        //),
        // Specifies info about where and how the <Logout Response> message MUST be
        // returned to the requester, in this case our SP.
        'singleLogoutService' => array (
            // URL Location where the <Response> from the IdP will be returned
            'url' => $spBaseUrl.'/sls.php',
            // SAML protocol binding to be used when returning the <Response>
            // message.  Onelogin Toolkit supports for this endpoint the
            // HTTP-Redirect binding only
            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
        ),
        // Specifies constraints on the name identifier to be used to
        // represent the requested subject.
        // Take a look on lib/Saml2/Constants.php to see the NameIdFormat supported
        'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',

        // Usually x509cert and privateKey of the SP are provided by files placed at
        // the certs folder. But we can also provide them with the following parameters
        'x509cert' => '-----BEGIN CERTIFICATE-----
MIID+zCCAuOgAwIBAgIUajlYWf3ln4Y6urvtcvvKK0RHfqgwDQYJKoZIhvcNAQEL
BQAwgYwxIzAhBgkqhkiG9w0BCQEWFGFkbWluQG1hdHJhZGUuZ292Lm15MQswCQYD
VQQGEwJNWTEMMAoGA1UECAwDS1VMMQwwCgYDVQQHDANLVUwxEDAOBgNVBAoMB01B
VFJBREUxCzAJBgNVBAsMAklUMR0wGwYDVQQDDBRrbXN0Zy5tYXRyYWRlLmdvdi5t
eTAeFw0yMTA4MjAwMzIzMTBaFw0yMzA4MjAwMzIzMTBaMIGMMSMwIQYJKoZIhvcN
AQkBFhRhZG1pbkBtYXRyYWRlLmdvdi5teTELMAkGA1UEBhMCTVkxDDAKBgNVBAgM
A0tVTDEMMAoGA1UEBwwDS1VMMRAwDgYDVQQKDAdNQVRSQURFMQswCQYDVQQLDAJJ
VDEdMBsGA1UEAwwUa21zdGcubWF0cmFkZS5nb3YubXkwggEiMA0GCSqGSIb3DQEB
AQUAA4IBDwAwggEKAoIBAQDK+cJ9Lt0FiIWjKa7EeO1d7UePAZu0+4GYxChgkYlR
GSM934YcyuyWPsm9WrbQAY8+Rd7FKWPOQsa9TgPUncN29lmTaDhbW/1GLf0bokGx
LVFIG7yQPqB4UnO1aHu+CdgvI4+ojL+vE/ocvxG8wak9QM9fHWcGKV5AFWy78dKb
IpSwzD4iV0gIJKwZ2+AphfXfidnMqB8SLUj0+yJk3Xop/0ydF1EI89u1UryWxb9Q
+rDST70hGueSnQRfy8sVYiFnioJW/43/X8fIuuLFjiQjGbtSMiFkJTnuJzrUTsoz
zUS6nO1D6Stx8jAgJ5qSFVJypbmbZ1aKDZX5vc+gA6ZHAgMBAAGjUzBRMB0GA1Ud
DgQWBBQ2nASECST37Qb1QgX1aGmcmYuCiTAfBgNVHSMEGDAWgBQ2nASECST37Qb1
QgX1aGmcmYuCiTAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQBQ
lHJR0JsjRB6It8zbIHG7mCkPCCg6M0sXgGF03dD85BPh9Mg4JbvVGSSqJb7nXARL
zEQ6ZAIBEJBdIJyfTXbsMWQ57+ySVj9VJ2Z0Hh50ZLb86QPwC88qCUrnHkeH8ZzL
pl8wVxdevUOT9jfWcMCtUMgJayYl9A+5tVxnHcSwJP4Da1V3UUBOs/QIaszI0xkz
DA9obiuc/fjPuXtoUi8ZM8d1NC6/DXrz+3SPktu1Ag31adZYdo3tsw14Rk7xWnM7
H4F986RR53xeSAmhbRbSAbdWAckaig77deIL0NzQGhV/yJUq+GzqzQSZwVmhfWOO
Vv2xycVSRS8LNOE5KxwA
-----END CERTIFICATE-----
',
        'privateKey' => '-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDK+cJ9Lt0FiIWj
Ka7EeO1d7UePAZu0+4GYxChgkYlRGSM934YcyuyWPsm9WrbQAY8+Rd7FKWPOQsa9
TgPUncN29lmTaDhbW/1GLf0bokGxLVFIG7yQPqB4UnO1aHu+CdgvI4+ojL+vE/oc
vxG8wak9QM9fHWcGKV5AFWy78dKbIpSwzD4iV0gIJKwZ2+AphfXfidnMqB8SLUj0
+yJk3Xop/0ydF1EI89u1UryWxb9Q+rDST70hGueSnQRfy8sVYiFnioJW/43/X8fI
uuLFjiQjGbtSMiFkJTnuJzrUTsozzUS6nO1D6Stx8jAgJ5qSFVJypbmbZ1aKDZX5
vc+gA6ZHAgMBAAECggEAEEjdi8GYxfrgDekoNmclVCXXWefdIDYVfbYvLyA+Dh2g
MDSgw+qb9Knw8Zo3lJSrc2mTp+ncMg41d7aspABMUF0Pbr4r11iYB2tlJTRtZNOn
88sV49TCdyTWV7WcR/DuQUnvGqzALEHEDU5fE+/NrjZm7NClFV94Slfts16BcSS+
iO4RzXUVxenoKfqXpOxe31xSbFpn1hWhwwe8ZgwLO1Gggna2Az0ywlOHpnvt5751
5I+8J4m/UpuOBKqXlBNH3o+dM642AW3k29JzshFihR+Bym3/3AwquknM5+RlPBs0
JEqZKuO9fVTL3hMH/QP1fBtKyXZm0lO8I2BSt4AlUQKBgQDmRyL9wK5s23EZcBtf
VRvBEeTuHfMtZKQ6KciXEnPbHIEje2hFQqoOAfYnZsCAC+gEL2U/z9/uDcRm+AQc
Uvfc9e1Y6hvQZ3g6ASgq4KWD34KlBNa8g0RNPMyyG+QqhKOszxE1Pe3cBwW+GOz1
wse43M6AfCfoUSDnwVd2Oo8ZywKBgQDhpeg3vPRcDRHtCHYgc597BilDrU2el7/K
TnvlTrDWfYe2OWJKfJ0PQee7v2Cp6WzDqiPPDPmYB2JF85TXPDCfsTmn2l5BEVYo
heDWP//ewRsVbcsR0J2ZtO5KtQrZTlmWYv1I8WQqQ/WjQgAFTnpeR84fq5rzGrYH
wGkrJs0F9QKBgQCv2NbRq9gG7LQ7Vq6waA+fqgiGBXzzxwzaFZpGMyMhyWycKdsA
ON4fgEP25rJNlcoBmCfbSOSZpw26C98nufvpUiuDYJMI3FqlAMkppQ7/2yiq1z0c
C6mWyb0OrdnY1h0fE6jyXW5MPViXR/V73tghRQy0dRsMfxd/otclQ6aPbQKBgDxK
nySdeVFLMLn748xB+J/fgpERskao11cP52zavMdi3SskZA3xA+o6utdgiEx+EVCq
mkzNc7daabi1H9TuwTM6IGSoJT0Pi8ziELROf2iegkUUhAjri+CxBmaxvwdXNvrG
0lR2I0RjyjNoBCdm061zVDEEIi/IuFCT6cXc5TUtAoGBAIv++WkNSNcVrtzcxmvY
9kEAUTFiZiGE9RQPlancpIsb8giZdC4iX6y41SGt8BBc7RRJVVpzg6+YPAGAaHAJ
oo+3EXYCjxwqRGeqh42DLcKqUJTH+Oo7QWfbax4/meaFRVxs+I93AZtu/u/xSxO7
u8g2DScLyDCzeey92lIh2NjR
-----END PRIVATE KEY-----
',

        /*
         * Key rollover
         * If you plan to update the SP x509cert and privateKey
         * you can define here the new x509cert and it will be 
         * published on the SP metadata so Identity Providers can
         * read them and get ready for rollover.
         */
        // 'x509certNew' => '',
    ),

    // Identity Provider Data that we want connect with our SP
    'idp' => array (
        // Identifier of the IdP entity  (must be a URI)
        'entityId' => 'http://logon.matrade.gov.my/adfs/services/trust',
        // SSO endpoint info of the IdP. (Authentication Request protocol)
        'singleSignOnService' => array (
            // URL Target of the IdP where the SP will send the Authentication Request Message
            'url' => 'https://logon.matrade.gov.my/adfs/ls/idpinitiatedsignon.htm',
            // SAML protocol binding to be used when returning the <Response>
            // message.  Onelogin Toolkit supports for this endpoint the
            // HTTP-Redirect binding only
            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
        ),
        // SLO endpoint info of the IdP.
        'singleLogoutService' => array (
            // URL Location of the IdP where the SP will send the SLO Request
            'url' => 'https://logon.matrade.gov.my/adfs/ls',
            // URL location of the IdP where the SP will send the SLO Response (ResponseLocation)
            // if not set, url for the SLO Request will be used
            'responseUrl' => 'https://logon.matrade.gov.my/adfs/ls',
            // SAML protocol binding to be used when returning the <Response>
            // message.  Onelogin Toolkit supports for this endpoint the
            // HTTP-Redirect binding only
            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
        ),
        // Public x509 certificate of the IdP
        'x509cert' => '-----BEGIN CERTIFICATE-----
MIIC5DCCAcygAwIBAgIQG8IKOTGQMLFLT+BcbZB2cjANBgkqhkiG9w0BAQsFADAu
MSwwKgYDVQQDEyNBREZTIFNpZ25pbmcgLSBsb2dvbi5tYXRyYWRlLmdvdi5teTAe
Fw0yMDEwMDYwOTMzMTFaFw0yMzEwMDYwOTMzMTFaMC4xLDAqBgNVBAMTI0FERlMg
U2lnbmluZyAtIGxvZ29uLm1hdHJhZGUuZ292Lm15MIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEAuVJvxh3zZ4N+4vDOiTTYIIlBbCsioWLzwCQ5AdItfh63
h0nN/LpJ2+laBlluLSsQG85o2TURH6XC4uZU97TA6Pk2YdhVmobiz8QHjVotHJlF
N/3ncBBu/ZSvA+9mgN4FVBawtGjmJeGvea6izqYh+8w8r7eXRXuqM+55+bpOUGH5
p78t35449M47tZogzFa+WzNmCON69nJ7gDF+9flGaAdldugW+tj3ToV+llUu7xsx
Rei++JDZyFhjX6ei3qLdWbkPtsO4GtcC1jWm4pElCk8VjX+ll5Hhw0X/RHC5JDrI
TBMZM7wTmsF4x5xiL4F2N+ghqTv6cfs7cSbuNG9p4QIDAQABMA0GCSqGSIb3DQEB
CwUAA4IBAQBdD/UB4ILClzWW7pJRWiA0zjwBtN0t88999kUrnY/sLqfC/sx8o7JJ
hEGGqu/5aFPP+SvqXUXCUXgHHT9MGMcTpHdqsddbnpRrXIDAYNY+vxOqUXRe4q8w
YzNaJFe4xxHvpqF/cd+18CMd8Bw4LGvcKnx+4zUHZAc8QP6wepwR689sVsc3aeSe
XYOkRsOXAMno5TmdQMpv2+2euGRKD/imgXHjnRdQLkNvgHdVegnKwxBrslCG82UK
pCmzwaUo130n1J60Xl5cDi7l2DNFCZP2ldIN3k+u7EO5WfGBS//f0rYbG4Ya+BGO
PgjTS+SCcp4zFs3c/Eih6d1De8PjGs0o
-----END CERTIFICATE-----
',
        /*
         *  Instead of use the whole x509cert you can use a fingerprint in
         *  order to validate the SAMLResponse, but we don't recommend to use
         *  that method on production since is exploitable by a collision
         *  attack.
         *  (openssl x509 -noout -fingerprint -in "idp.crt" to generate it,
         *   or add for example the -sha256 , -sha384 or -sha512 parameter)
         *
         *  If a fingerprint is provided, then the certFingerprintAlgorithm is required in order to
         *  let the toolkit know which Algorithm was used. Possible values: sha1, sha256, sha384 or sha512
         *  'sha1' is the default value.
         */
        // 'certFingerprint' => '',
        // 'certFingerprintAlgorithm' => 'sha1',

        /* In some scenarios the IdP uses different certificates for
         * signing/encryption, or is under key rollover phase and more 
         * than one certificate is published on IdP metadata.
         * In order to handle that the toolkit offers that parameter.
         * (when used, 'x509cert' and 'certFingerprint' values are
         * ignored).
         */
        // 'x509certMulti' => array(
        //      'signing' => array(
        //          0 => '<cert1-string>',
        //      ),
        //      'encryption' => array(
        //          0 => '<cert2-string>',
        //      )
        // ),
    ),
);
