<head>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/css/boxicons.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.0/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fabric.js/5.3.0/fabric.min.js"></script>

</head>
<style>
    .hidden-column {
        display: none !important;
    }

    .table-responsive {
        overflow-x: auto;
    }

    .btn-group .btn {
        margin-right: 5px;
    }

    .accordion-button:not(.collapsed) {
        background-color: #e7f3ff;
    }

    .card:hover {
        background-color: #f8f9fa;
        cursor: pointer;
    }

    .bi-chevron-right,
    .bi-chevron-down {
        transition: transform 0.2s;
    }

    .export-notification {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 1050;
        min-width: 300px;
    }

    /* ADD THESE SORTING STYLES */
    .sortable-header {
        cursor: pointer;
        position: relative;
        user-select: none;
        padding-right: 25px !important;
    }

    .sortable-header:hover {
        background-color: #f8f9fa;
    }

    .sort-icon {
        position: absolute;
        right: 8px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 12px;
        color: #6c757d;
        transition: color 0.2s;
    }

    .sort-icon.active {
        color: #0d6efd;
    }

    #annotationCanvas {
    pointer-events: none;
  }
  #annotationCanvas.active {
    pointer-events: auto;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 9999;
  }
</style>
</head>

<body>
    <!-- Export notification area -->
    <div id="exportNotification" class="export-notification"></div>

    <div class="container-fluid py-4">
        <!-- RESULTS SECTION -->
        <div class="unified-container">
            <div class="results-section">
                <div class="accordion" id="divisionsAccordion">

                    <!-- First Division: MANAGEMENT SERVICES DIVISION -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                MANAGEMENT SERVICES DIVISION
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#divisionsAccordion">
                            <div class="accordion-body p-0">
                                <!-- Nested Accordion for Sections -->
                                <div class="accordion" id="sectionsAccordionOne">
                                    <div class="accordion-item border-0">
                                        <h2 class="accordion-header" id="headingOneOne">
                                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOneOne" aria-expanded="false" aria-controls="collapseOneOne">
                                                FACILITY MANAGEMENT SECTION
                                            </button>
                                        </h2>
                                        <div id="collapseOneOne" class="accordion-collapse collapse" aria-labelledby="headingOneOne" data-bs-parent="#sectionsAccordionOne">
                                            <div class="accordion-body">
                                                <!-- ASSET MANAGEMENT UNIT Card -->
                                                <div class="card mb-2" onclick="toggleTable('assetManagementTable')">
                                                    <div class="card-body d-flex justify-content-between align-items-center">
                                                        <div>ASSET MANAGEMENT UNIT</div>
                                                        <div><i class="bi bi-chevron-right"></i></div>
                                                    </div>
                                                </div>

                                                <!-- ASSET MANAGEMENT UNIT Table (initially hidden) -->
                                                <div id="assetManagementTable" style="display:none; margin-top: 20px;">
                                                    <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                                                        <h5>Asset Management Unit Performance - Q1 2025</h5>
                                                        <div class="btn-group">
                                                            <button class="btn btn-primary btn-sm" onclick="openColumnModal()">
                                                                <i class="bx bx-columns me-1"></i> Modify Column
                                                            </button>
                                                            <button class="btn btn-info btn-sm" onclick="printTable()">
                                                                <i class="bx bx-printer me-1"></i> Print
                                                            </button>
                                                            <div class="dropdown">
                                                                <button type="button" class="btn btn-danger btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                                                                    <i class="bx bx-download me-1"></i> Export
                                                                </button>
                                                                <ul class="dropdown-menu">
                                                                    <li>
                                                                        <h6 class="dropdown-header">CHOOSE AN OPTION:</h6>
                                                                    </li>
                                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('excel', 'mainTable')"><i class="bi bi-file-earmark-excel me-2"></i>EXCEL</a></li>
                                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('pdf', 'mainTable')"><i class="bi bi-file-earmark-pdf me-2"></i>PDF</a></li>
                                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('word', 'mainTable')"><i class="bi bi-file-earmark-word me-2"></i>WORD</a></li>
                                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('jpg', 'mainTable')"><i class="bi bi-image me-2"></i>JPG</a></li>
                                                                </ul>
                                                            </div>
                                                            <div class="dropdown">
                                                                <button class="btn btn-success btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                                                                    <i class="bx bx-edit me-1"></i> Annotation
                                                                </button>
                                                                <ul class="dropdown-menu">
                                                                    <a class="dropdown-item" href="javascript:void(0)" onclick="startAnnotation()">Start Annotate</a>
                                                                    <a class="dropdown-item" href="javascript:void(0)" onclick="saveCanvas()">Download Annotated</a>
                                                                    <a class="dropdown-item" href="javascript:void(0)" onclick="stopAnnotation()">Stop Annotation</a>

                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="table-responsive">
                                                       <table class="table table-bordered" id="mainTable">
                                                            <thead class="table-light">
                                                                <tr>

                                                                    <th data-column="no" class="sortable-header" onclick="sortTable('mainTable', 0, 'number')">
                                                                        No.
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="year" class="sortable-header" onclick="sortTable('mainTable', 1, 'number')">
                                                                        Year
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="division" class="sortable-header" onclick="sortTable('mainTable', 2, 'text')">
                                                                        Division
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="section" class="sortable-header" onclick="sortTable('mainTable', 3, 'text')">
                                                                        Section
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="unit-office" class="sortable-header" onclick="sortTable('mainTable', 4, 'text')">
                                                                        Unit/Office
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="indicator" class="sortable-header" onclick="sortTable('mainTable', 5, 'text')">
                                                                        Indicator
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="description" class="sortable-header" onclick="sortTable('mainTable', 6, 'text')">
                                                                        Description
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="metric" class="sortable-header" onclick="sortTable('mainTable', 7, 'text')">
                                                                        Metric
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="annual-target" class="sortable-header" onclick="sortTable('mainTable', 8, 'number')">
                                                                        Annual Target
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="indicator-type" class="sortable-header" onclick="sortTable('mainTable', 9, 'text')">
                                                                        Indicator Type
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="indicator-type-definition" class="sortable-header" onclick="sortTable('mainTable', 10, 'text')">
                                                                        Indicator Type Definition
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="category" class="sortable-header" onclick="sortTable('mainTable', 11, 'text')">
                                                                        Category
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="component-achievement" class="sortable-header" onclick="sortTable('mainTable', 12, 'number')">
                                                                        Component Achievement
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="output-outcome" class="sortable-header" onclick="sortTable('mainTable', 13, 'text')">
                                                                        Output/Outcome
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="submission" class="sortable-header" onclick="sortTable('mainTable', 14, 'text')">
                                                                        Submission
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="status" class="sortable-header" onclick="sortTable('mainTable', 15, 'text')">
                                                                        Status
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    <th data-column="pmu-remarks" class="sortable-header" onclick="sortTable('mainTable', 16, 'text')">
                                                                        PMU Remarks
                                                                        <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                    </th>
                                                                    </th>

                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <td data-column="no">1</td>
                                                                    <td data-column="year">2024</td>
                                                                    <td data-column="division">Operations</td>
                                                                    <td data-column="section">Maintenance</td>
                                                                    <td data-column="unit-office">Asset Management</td>
                                                                    <td data-column="indicator">Asset Maintenance</td>
                                                                    <td data-column="description">Total maintenance tasks resolved</td>
                                                                    <td data-column="metric">Tasks Completed</td>
                                                                    <td data-column="annual-target">300</td>
                                                                    <td data-column="indicator-type">Efficiency</td>
                                                                    <td data-column="indicator-type-definition">Measure of operational efficiency</td>
                                                                    <td data-column="category">Operations</td>
                                                                    <td data-column="component-achievement">75</td>
                                                                    <td data-column="output-outcome">Output</td>
                                                                    <td data-column="submission">Q1 2024</td>
                                                                    <td data-column="status"><span class="badge bg-warning">Ongoing</span></td>
                                                                    <td data-column="pmu-remarks">25% completion - accelerating</td>
                                                                </tr>
                                                                <tr>
                                                                    <td data-column="no">2</td>
                                                                    <td data-column="year">2024</td>
                                                                    <td data-column="division">Quality Assurance</td>
                                                                    <td data-column="section">Audit</td>
                                                                    <td data-column="unit-office">Asset Management</td>
                                                                    <td data-column="indicator">Asset Audit</td>
                                                                    <td data-column="description">Audited vs. planned assets</td>
                                                                    <td data-column="metric">Audit Percentage</td>
                                                                    <td data-column="annual-target">100</td>
                                                                    <td data-column="indicator-type">Quality</td>
                                                                    <td data-column="indicator-type-definition">Quality assurance metric</td>
                                                                    <td data-column="category">Compliance</td>
                                                                    <td data-column="component-achievement">40</td>
                                                                    <td data-column="output-outcome">Output</td>
                                                                    <td data-column="submission">Q1 2024</td>
                                                                    <td data-column="status"><span class="badge bg-info">In Progress</span></td>
                                                                    <td data-column="pmu-remarks">40% completion - on track</td>
                                                                </tr>
                                                                <tr>
                                                                    <td data-column="no">3</td>
                                                                    <td data-column="year">2024</td>
                                                                    <td data-column="division">Finance</td>
                                                                    <td data-column="section">Budget</td>
                                                                    <td data-column="unit-office">Finance Department</td>
                                                                    <td data-column="indicator">Cost Savings</td>
                                                                    <td data-column="description">Total cost reduction achieved</td>
                                                                    <td data-column="metric">Currency (RM)</td>
                                                                    <td data-column="annual-target">50,000</td>
                                                                    <td data-column="indicator-type">Financial</td>
                                                                    <td data-column="indicator-type-definition">Financial performance indicator</td>
                                                                    <td data-column="category">Finance</td>
                                                                    <td data-column="component-achievement">12,500</td>
                                                                    <td data-column="output-outcome">Outcome</td>
                                                                    <td data-column="submission">Q1 2024</td>
                                                                    <td data-column="status"><span class="badge bg-success">Achieved</span></td>
                                                                    <td data-column="pmu-remarks">25% of annual target in Q1</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>

                                                        <div id="annotationToolbar" class="d-none mb-2">
                                                        <button onclick="setMode('draw')" class="btn btn-sm btn-dark">✏️ Pen</button>
                                                        <button onclick="setMode('erase')" class="btn btn-sm btn-dark">🧽 Erase</button>
                                                        <button onclick="clearCanvas()" class="btn btn-sm btn-warning">❌ Clear</button>
                                                        <button onclick="saveCanvas()" class="btn btn-sm btn-success">✅ Save</button>
                                                        <button onclick="stopAnnotation()" class="btn btn-sm btn-danger">✖️ Stop</button>
                                                        </div>

                                                        <canvas id="annotationCanvas" class="d-none"></canvas>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Second Division: EXPORTER PROMOTION -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                EXPORTER PROMOTION AND MARKET ACCESS DIVISION
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#divisionsAccordion">
                            <div class="accordion-body p-0">
                                <div class="accordion" id="sectionsAccordionTwo">
                                    <div class="accordion-item border-0">
                                        <h2 class="accordion-header" id="headingTwoOne">
                                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwoOne" aria-expanded="false" aria-controls="collapseTwoOne">
                                                ELECTRICAL & ELECTRONICS, ICT, MACHINERY SECTION
                                            </button>
                                        </h2>
                                        <div id="collapseTwoOne" class="accordion-collapse collapse" aria-labelledby="headingTwoOne" data-bs-parent="#sectionsAccordionTwo">
                                            <div class="accordion-body">
                                                <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                                                    <h5>E&E, ICT, MACHINERY SECTION - Q1 2025</h5>
                                                    <div class="btn-group">
                                                        <button class="btn btn-primary btn-sm" onclick="openColumnModal()">
                                                            <i class="bx bx-columns me-1"></i> Modify Column
                                                        </button>
                                                        <button class="btn btn-info btn-sm" onclick="printTable()">
                                                            <i class="bx bx-printer me-1"></i> Print
                                                        </button>
                                                        <div class="dropdown">
                                                            <button type="button" class="btn btn-danger btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                                                                <i class="bx bx-download me-1"></i> Export
                                                            </button>
                                                            <ul class="dropdown-menu">
                                                                <li>
                                                                    <h6 class="dropdown-header">CHOOSE AN OPTION:</h6>
                                                                </li>
                                                                <li><a class="dropdown-item" href="#" onclick="exportTable('excel', 'exporterTable')"><i class="bi bi-file-earmark-excel me-2"></i>EXCEL</a></li>
                                                                <li><a class="dropdown-item" href="#" onclick="exportTable('pdf', 'exporterTable')"><i class="bi bi-file-earmark-pdf me-2"></i>PDF</a></li>
                                                                <li><a class="dropdown-item" href="#" onclick="exportTable('word', 'exporterTable')"><i class="bi bi-file-earmark-word me-2"></i>WORD</a></li>
                                                                <li><a class="dropdown-item" href="#" onclick="exportTable('jpg', 'exporterTable')"><i class="bi bi-image me-2"></i>JPG</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="dropdown">
                                                            <button class="btn btn-success btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                                                                <i class="bx bx-edit me-1"></i> Annotation
                                                            </button>
                                                            <ul class="dropdown-menu">
                                                                <li><a class="dropdown-item" href="#">Start Annotate</a></li>
                                                                <li><a class="dropdown-item" href="#">Download Annotated</a></li>
                                                                <li><a class="dropdown-item" href="#">Stop Annotation</a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table table-bordered" id="mainTable">
                                                        <thead class="table-light">
                                                            <tr>
                                                                <th class="sortable-header" onclick="sortTable('exporterTable', 0, 'number')">
                                                                    No.
                                                                    <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                </th>
                                                                <th class="sortable-header" onclick="sortTable('exporterTable', 1, 'text')">
                                                                    Indicator
                                                                    <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                </th>
                                                                <th class="sortable-header" onclick="sortTable('exporterTable', 2, 'text')">
                                                                    Description
                                                                    <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                </th>
                                                                <th class="sortable-header" onclick="sortTable('exporterTable', 3, 'number')">
                                                                    Target
                                                                    <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                </th>
                                                                <th class="sortable-header" onclick="sortTable('exporterTable', 4, 'number')">
                                                                    Achievement
                                                                    <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                </th>
                                                                <th class="sortable-header" onclick="sortTable('exporterTable', 5, 'text')">
                                                                    Percentage
                                                                    <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                </th>
                                                                <th class="sortable-header" onclick="sortTable('exporterTable', 6, 'text')">
                                                                    Remarks
                                                                    <i class="bi bi-arrow-down-up sort-icon"></i>
                                                                </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>1</td>
                                                                <td>Export Support</td>
                                                                <td>Company export facilitation</td>
                                                                <td>50</td>
                                                                <td>12</td>
                                                                <td>24%</td>
                                                                <td>In progress</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Third Division: TRANSFORMATION -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                TRANSFORMATION AND DIGITAL TRADE DIVISION
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#divisionsAccordion">
                            <div class="accordion-body">
                                <div class="card mb-2" onclick="toggleTable('transformationTable')">
                                    <div class="card-body d-flex justify-content-between align-items-center">
                                        <div>DIGITAL TRANSFORMATION UNIT</div>
                                        <div><i class="bi bi-chevron-right"></i></div>
                                    </div>
                                </div>

                                <div id="transformationTable" style="display:none; margin-top: 20px;">
                                    <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                                        <h5>Digital Transformation - Q1 2025</h5>

                                        <div class="btn-group">
                                            <button class="btn btn-primary btn-sm" onclick="openColumnModal()">
                                                <i class="bx bx-columns me-1"></i> Modify Column
                                            </button>
                                            <button class="btn btn-info btn-sm" onclick="printTable()">
                                                <i class="bx bx-printer me-1"></i> Print
                                            </button>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-danger btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                                                    <i class="bx bx-download me-1"></i> Export
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li>
                                                        <h6 class="dropdown-header">CHOOSE AN OPTION:</h6>
                                                    </li>
                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('excel', 'transformationTableData')"><i class="bi bi-file-earmark-excel me-2"></i>EXCEL</a></li>
                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('pdf', 'transformationTableData')"><i class="bi bi-file-earmark-pdf me-2"></i>PDF</a></li>
                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('word', 'transformationTableData')"><i class="bi bi-file-earmark-word me-2"></i>WORD</a></li>
                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('jpg', 'transformationTableData')"><i class="bi bi-image me-2"></i>JPG</a></li>
                                                </ul>
                                            </div>
                                            <div class="dropdown">
                                                <button class="btn btn-success btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                                                    <i class="bx bx-edit me-1"></i> Annotation
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li><a class="dropdown-item" href="#"><i data-feather="play" class="me-2"></i>Start Annotate</a></li>
                                                    <li><a class="dropdown-item" href="#"><i data-feather="download" class="me-2"></i>Download Annotated</a></li>
                                                    <li><a class="dropdown-item" href="#"><i data-feather="stop-circle" class="me-2"></i>Stop Annotation</a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="table-responsive">
                                      <table class="table table-bordered" id="mainTable">
                                            <thead class="table-light">
                                                <tr>
                                                           <th class="sortable-header" onclick="sortTable('transformationTableData', 0, 'number')">
            No.
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('transformationTableData', 1, 'text')">
            Initiative
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('transformationTableData', 2, 'text')">
            Progress
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('transformationTableData', 3, 'text')">
            Status
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>1</td>
                                                    <td>Digital Platform Development</td>
                                                    <td>75%</td>
                                                    <td><span class="badge bg-success">On Track</span></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/feather-icons/4.29.0/feather.min.js"></script>
    <script>
        // Toggle table visibility
        function toggleTable(tableId) {
            const table = document.getElementById(tableId);
            const chevronContainer = table.parentElement.querySelector('.card-body');
            const chevron = chevronContainer ? chevronContainer.querySelector('.bi-chevron-right, .bi-chevron-down') : null;

            if (table.style.display === 'none' || table.style.display === '') {
                table.style.display = 'block';
                if (chevron) {
                    chevron.className = chevron.className.replace('bi-chevron-right', 'bi-chevron-down');
                }
            } else {
                table.style.display = 'none';
                if (chevron) {
                    chevron.className = chevron.className.replace('bi-chevron-down', 'bi-chevron-right');
                }
            }
        }

        // Open column selector modal
        function openColumnModal() {
            // Assuming you have a modal with this ID in your other file
            const modal = new bootstrap.Modal(document.getElementById('columnSelectorModal'));
            modal.show();
        }

        // Column visibility management - FIXED VERSION
        function applyColumnVisibility() {
            const checkboxes = document.querySelectorAll('.column-toggle');
            const table = document.getElementById('mainTable');

            if (!table || checkboxes.length === 0) {
                // If no checkboxes exist, show all columns by default
                return;
            }

            checkboxes.forEach(checkbox => {
                const columnName = checkbox.dataset.column;
                const isVisible = checkbox.checked;

                // Find all elements with matching data-column attribute
                const elements = table.querySelectorAll(`[data-column="${columnName}"]`);

                elements.forEach(element => {
                    if (isVisible) {
                        element.classList.remove('hidden-column');
                        element.style.display = ''; // Reset display property
                    } else {
                        // Don't hide the "No" column as it's required
                        if (columnName !== 'no') {
                            element.classList.add('hidden-column');
                        }
                    }
                });
            });
        }

        // Select all columns
        function selectAllColumns() {
            const checkboxes = document.querySelectorAll('.column-toggle');
            checkboxes.forEach(checkbox => {
                checkbox.checked = true;
            });
        }

        // Deselect all columns (except required ones)
        function deselectAllColumns() {
            const checkboxes = document.querySelectorAll('.column-toggle');
            checkboxes.forEach(checkbox => {
                if (checkbox.dataset.column !== 'no') { // Keep "No" column checked
                    checkbox.checked = false;
                }
            });
        }

        // Apply column settings
        function applyColumnSettings() {
            applyColumnVisibility();
        }

        // Export functions
        function exportTable(format) {
            alert(`Exporting table as ${format.toUpperCase()}...`);
        }

        function printTable() {
            window.print();
        }

        // Form element focus effects
        document.querySelectorAll('.form-select, .form-control').forEach(element => {
            element.addEventListener('focus', function() {
                this.style.transform = 'translateY(-1px)';
            });

            element.addEventListener('blur', function() {
                this.style.transform = 'translateY(0)';
            });
        });

        // Initialize on page load - ENSURE ALL COLUMNS ARE VISIBLE BY DEFAULT
        document.addEventListener('DOMContentLoaded', function() {
            // Make sure all columns are visible initially
            const table = document.getElementById('mainTable');
            if (table) {
                const allColumns = table.querySelectorAll('[data-column]');
                allColumns.forEach(element => {
                    element.classList.remove('hidden-column');
                    element.style.display = ''; // Ensure display is not set to none
                });
            }

            // Only apply column visibility if checkboxes exist
            const checkboxes = document.querySelectorAll('.column-toggle');
            if (checkboxes.length > 0) {
                applyColumnVisibility();
            }
            if (typeof feather !== 'undefined') {
                feather.replace();
            }

        });


        // Event listeners for modal controls (if they exist)
        document.addEventListener('DOMContentLoaded', function() {
            const selectAllBtn = document.getElementById('selectAllColumns');
            const deselectAllBtn = document.getElementById('deselectAllColumns');
            const applyBtn = document.getElementById('applyColumnSettings');
            const noColumnCheckbox = document.getElementById('noColumn');

            if (selectAllBtn) {
                selectAllBtn.addEventListener('click', selectAllColumns);
            }

            if (deselectAllBtn) {
                deselectAllBtn.addEventListener('click', deselectAllColumns);
            }

            if (applyBtn) {
                applyBtn.addEventListener('click', applyColumnSettings);
            }

            // Prevent unchecking the required "No" column
            if (noColumnCheckbox) {
                noColumnCheckbox.addEventListener('change', function() {
                    if (!this.checked) {
                        this.checked = true;
                        alert('The "No" column is required and cannot be unchecked.');


                    }
                });
            }
        });

         // ADD THESE SORTING FUNCTIONS
    let sortDirections = {}; // Track sort direction for each column

    function sortTable(tableId, columnIndex, dataType) {
        const table = document.getElementById(tableId);
        const tbody = table.querySelector('tbody');
        const rows = Array.from(tbody.querySelectorAll('tr'));
        const header = table.querySelector(`thead th:nth-child(${columnIndex + 1})`);
        const sortIcon = header.querySelector('.sort-icon');

        // Clear other active sort icons
        table.querySelectorAll('.sort-icon').forEach(icon => {
            if (icon !== sortIcon) {
                icon.classList.remove('active');
                icon.className = 'bi bi-arrow-down-up sort-icon';
            }
        });

        // Determine sort direction
        const sortKey = `${tableId}_${columnIndex}`;
        const currentDirection = sortDirections[sortKey] || 'asc';
        const newDirection = currentDirection === 'asc' ? 'desc' : 'asc';
        sortDirections[sortKey] = newDirection;

        // Update sort icon
        sortIcon.classList.add('active');
        sortIcon.className = newDirection === 'asc' ?
            'bi bi-arrow-up sort-icon active' :
            'bi bi-arrow-down sort-icon active';

        // Sort rows
        rows.sort((a, b) => {
            const aCell = a.cells[columnIndex];
            const bCell = b.cells[columnIndex];

            let aValue = aCell.textContent.trim();
            let bValue = bCell.textContent.trim();

            // Handle status badges - extract text content
            if (aCell.querySelector('.badge')) {
                aValue = aCell.querySelector('.badge').textContent.trim();
            }
            if (bCell.querySelector('.badge')) {
                bValue = bCell.querySelector('.badge').textContent.trim();
            }

            // Convert to appropriate data type
            if (dataType === 'number') {
                // Remove commas and convert to number
                aValue = parseFloat(aValue.replace(/,/g, '')) || 0;
                bValue = parseFloat(bValue.replace(/,/g, '')) || 0;

                if (newDirection === 'asc') {
                    return aValue - bValue;
                } else {
                    return bValue - aValue;
                }
            } else {
                // Text sorting (alphabetical)
                aValue = aValue.toLowerCase();
                bValue = bValue.toLowerCase();

                if (newDirection === 'asc') {
                    return aValue.localeCompare(bValue);
                } else {
                    return bValue.localeCompare(aValue);
                }
            }
        });

        // Clear tbody and re-append sorted rows
        tbody.innerHTML = '';
        rows.forEach(row => tbody.appendChild(row));

        // Add visual feedback
        header.style.backgroundColor = '#e3f2fd';
        setTimeout(() => {
            header.style.backgroundColor = '';
        }, 300);
    }

    // Reset sort directions when table is toggled
    function toggleTable(tableId) {
        const table = document.getElementById(tableId);
        const chevronContainer = table.parentElement.querySelector('.card-body');
        const chevron = chevronContainer ? chevronContainer.querySelector('.bi-chevron-right, .bi-chevron-down') : null;

        if (table.style.display === 'none' || table.style.display === '') {
            table.style.display = 'block';
            if (chevron) {
                chevron.className = chevron.className.replace('bi-chevron-right', 'bi-chevron-down');
            }
        } else {
            table.style.display = 'none';
            if (chevron) {
                chevron.className = chevron.className.replace('bi-chevron-down', 'bi-chevron-right');
            }
            // Reset sort directions when table is hidden
            Object.keys(sortDirections).forEach(key => {
                if (key.startsWith(tableId)) {
                    delete sortDirections[key];
                }
            });
        }
    }
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/fabric.js/5.3.0/fabric.min.js"></script>
<script>
  let canvas;
  let fabricCanvas;

  function startAnnotation() {
    const table = document.getElementById("mainTable");
    const canvasEl = document.getElementById("annotationCanvas");
    const toolbar = document.getElementById("annotationToolbar");
    const rect = table.getBoundingClientRect();

    // Set canvas size & position same as table
    canvasEl.width = rect.width;
    canvasEl.height = rect.height;
    canvasEl.style.top = `${rect.top + window.scrollY}px`;
    canvasEl.style.left = `${rect.left + window.scrollX}px`;
    canvasEl.classList.add("active");
    canvasEl.classList.remove("d-none");
    toolbar.classList.remove("d-none");

    // Init fabric
    fabricCanvas = new fabric.Canvas("annotationCanvas", {
      isDrawingMode: true,
      selection: false,
    });
    fabricCanvas.freeDrawingBrush.width = 2;
    fabricCanvas.freeDrawingBrush.color = "#000";
  }

  function setMode(mode) {
    if (!fabricCanvas) return;
    fabricCanvas.isDrawingMode = true;
    fabricCanvas.freeDrawingBrush.color = mode === "erase" ? "#fff" : "#000";
  }

  function clearCanvas() {
    if (fabricCanvas) fabricCanvas.clear();
  }

  function saveCanvas() {
    if (!fabricCanvas) return;
    const dataUrl = fabricCanvas.toDataURL("png");
    const a = document.createElement("a");
    a.href = dataUrl;
    a.download = "annotation.png";
    a.click();
  }

  function stopAnnotation() {
    if (!fabricCanvas) return;
    fabricCanvas.dispose();
    document.getElementById("annotationCanvas").classList.add("d-none");
    document.getElementById("annotationToolbar").classList.add("d-none");
  }
</script>


</body>

</html>
