@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Indicator - Listing')

@section('page-script')
@vite(['resources/assets/js/kpi-indicator-pmu-admin.js'])
@endsection

@section('content')

<!-- DataTables CSS & JS -->
<link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="{{ asset('assets/js/kpiIndicator.js') }}"></script>

 @php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'KPI Indicator'],
    ['label' => 'List of Endorsement']
  ];
@endphp

@include('layouts.partials.page-header', [
  'title' => 'List of Endorsement',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))->render()
])

<br>
<head>
 <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
<!-- Custom CSS for rounded table -->
<style>
  .table-rounded {
    border-radius: 0.5rem;
    overflow: hidden;
    border-collapse: separate;
    border-spacing: 0;
  }
  
  .table-rounded thead th:first-child {
    border-top-left-radius: 0.5rem;
  }
  
  .table-rounded thead th:last-child {
    border-top-right-radius: 0.5rem;
  }
  
  .table-rounded tbody tr:last-child td:first-child {
    border-bottom-left-radius: 0.5rem;
  }
  
  .table-rounded tbody tr:last-child td:last-child {
    border-bottom-right-radius: 0.5rem;
  }
  
  /* Center align checkboxes */
  .table th:first-child,
  .table td:first-child {
    text-align: center;
    width: 50px;
  }

.sortable-header {
    cursor: pointer;
    position: relative;
    user-select: none;
    padding-right: 25px !important;
}

.sortable-header:hover {
    background-color: #f8f9fa;
}

.sort-icon {
    position: absolute;
    right: 8px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 12px;
    color: #6c757d;
    transition: color 0.2s;
}

.sort-icon.active {
    color: #0d6efd;
}
</style>
</head>

    <!-- <div class="list-group">
                <a class="list-group-item list-group-item-action active" id="list-home-list" data-bs-toggle="list" href="javascript:void(0);">Listing</a>
                <a class="list-group-item list-group-item-action" id="list-profile-list" data-bs-toggle="list" href="{{url('pages/account-settings-notifications')}}">New</a>
                <a class="list-group-item list-group-item-action" id="list-messages-list" data-bs-toggle="list" href="#list-messages">Messages</a>
                <a class="list-group-item list-group-item-action" id="list-settings-list" data-bs-toggle="list" href="#list-settings">Settings</a>
              </div> -->
    <div class="card mb-6">
      <!-- Account -->
      <div class="card-body">
      <div class="d-flex align-items-start align-items-sm-center gap-6  border-bottom">
      <!-- <img src="{{asset('assets/img/avatars/1.png')}}" alt="user-avatar" class="d-block w-px-100 h-px-100 rounded" id="uploadedAvatar" /> -->
          <div class="button-wrapper">
         
            <!-- <label for="upload" class="btn btn-primary me-3 mb-4" tabindex="0">
              <span class="d-none d-sm-block">Upload new photo</span>
              <i class="bx bx-upload d-block d-sm-none"></i>
              <input type="file" id="upload" class="account-file-input" hidden accept="image/png, image/jpeg" />
            </label> -->
            <!-- <button type="button" class="btn btn-outline-secondary account-image-reset mb-4">
              <i class="bx bx-reset d-block d-sm-none"></i>
              <span class="d-none d-sm-block">Reset</span>
            </button>

            <div>Allowed JPG, GIF or PNG. Max size of 800K</div> -->
          </div>
        </div>
      </div>
      <div class="card-body pt-4">
        {{-- <form id="formAccountSettings" method="POST" onsubmit="return false"> --}}
          <div class="row g-6">

          <div class="card-body pt-4">
    <form id="formAccountSettings" method="POST" action="{{ url()->current() }}">
      {!! csrf_field() !!}
      <div class="row g-4">

        {{-- Year --}}
        <div class="col-md-4">
          <label class="form-label" for="year">Year</label>
          <select id="year" name="year" class="select2 form-select">
            <option value="">Please select</option>
            {{-- Year Added Start --}}
            <option value="2018">2018</option>
            <option value="2019">2019</option>
            <option value="2020">2020</option>
            <option value="2021">2021</option>
            <option value="2022">2022</option>
            {{-- Year Added End --}}
            <option value="2023">2023</option>
            <option value="2024">2024</option>
            <option value="2025">2025</option>
          </select>
        </div>

        {{-- Division --}}
        <div class="col-md-4">
          <label class="form-label" for="division">Division</label>
          <select id="division" name="division" class="select2 form-select">
            <option value="">Please select</option>
            <option value="ceo">CEO's Office</option>
            <option value="exports">Export Promotion & Market Access</option>
            <option value="management">Management Services</option>
            <option value="strategic">Strategic Planning</option>
            <option value="transformation">Transformation and Digital Trade Division</option>
          </select>
        </div>

        {{-- Section --}}
        <div class="col-md-4">
          <label class="form-label" for="section">Section</label>
          <select id="section" name="section" class="select2 form-select">
            <option value="">Please select</option>
            <option value="asean">ASEAN & Oceania</option>
            <option value="central">Central, West, South Asia & Africa Section</option>
            <option value="china">China & Northeast Asia</option>
            <option value="construction">Construction & Business Services</option>
            <option value="coordination">Coordination & Monitoring</option>
            <option value="corporate">Corporate Management</option>
            <option value="customised">Customised Programme</option>
            <option value="development">Development Assistance</option>
            <option value="digital">Digital Trade</option>
            <option value="electrical">Electrical & Electronics, ICT, Machinery & Equipment</option>
            <option value="europe">Europe & Americas</option>
            <option value="export">Export Academy</option>
            <option value="facility">Facility Management</option>
            <option value="finance">Finance Management</option>
            <option value="halal">Halal, Food & Beverages & Agro-based</option>
            <option value="human">Human Resource</option>
            <option value="information">Information Technology</option>
            <option value="lifestyle">Lifestyle & Life Sciences</option>
            <option value="na">N/A</option>
            <option value="oil">Oil & Gas, Chemical & Energy</option>
            <option value="research">Research</option>
            <option value="strategicCommunication">Strategic Communication</option>
            <option value="strategicDevelopment">Strategic Development</option>
            <option value="transport">Transport & Logistic</option>
            {{-- From Indicator Create Modal - Start --}}
            <option value="ceo">CEO OFFICE</option>
            <option value="exports">EXPORTS PROMOTION & MARKET ACCESS DIVISION</option>
            <option value="management">MANAGEMENT SERVICES DIVISION</option>
            {{-- From Indicator Create Modal - End --}}
          </select>
        </div>

        {{-- Unit/Office --}}
        <div class="col-md-4">
          <label class="form-label" for="unit">Unit/Office</label>
          <select id="unit" name="unit" class="select2 form-select">
            <option value="">Please select</option>
            @for ($i = 1; $i <= 87; $i++)
              <option value="unit{{ $i }}">Unit {{ $i }}</option>
            @endfor
            {{-- From Indicator Create Modal - Start --}}
              <option value="ceo">CEO OFFICE</option>
              <option value="exports">EXPORTS PROMOTION & MARKET ACCESS DIVISION</option>
              <option value="management">MANAGEMENT SERVICES DIVISION</option>
            {{-- From Indicator Create Modal - End --}}
          </select>
        </div>

        {{-- Indicator Type --}}
        <div class="col-md-4">
          <label class="form-label" for="indicator_type">Indicator Type</label>
          <select id="indicator_type" name="indicator_type" class="select2 form-select">
            <option value="">Please select</option>
            {{-- <option value="type1">Type 1</option>
            <option value="type2">Type 2</option>
            <option value="type3">Type 3</option>
            <option value="type4">Type 4</option>
            <option value="type5">Type 5</option>
            <option value="type6">Type 6</option> --}}
              @foreach ($indicator_type_list as $item)
                <option value="{{ $item->kpi_indicator_type_id }}">
                  {{ formatType($item->indicator_type) }}
                </option>
              @endforeach
          </select>
        </div>

        {{-- Status --}}
        <div class="col-md-4">
          <label class="form-label" for="status">Status</label>
          <select id="status" name="status" class="select2 form-select">
            <option value="">Please select</option>
            <option value="draft">Draft</option>
            <option value="submitted">Submitted</option>
            <option value="endorsed">Endorsed</option>
            <option value="pending">Pending Endorsed</option>
            <option value="proposed">Proposed</option>
            <option value="rejected">Rejected</option>
          </select>
        </div>

            <div class="col-md-4">
              <label for="indicator" class="form-label">Indicator</label>
              <select id="indicator" name="indicator" class="select2 form-select">
                <option value="">Please select</option>
                <option value="Programme">Programme</option>
                <option value="Export Sales">Export Sales</option>
                <option value="Companies Assisted">Companies Assisted</option>
              </select>
            </div>
          </div>
          <!-- <div class="mt-6">
            <button type="submit" class="btn btn-primary me-3">Search</button>
            <button type="reset" class="btn btn-outline-secondary">Reset</button>
          </div> -->
          <div class="mt-2 d-flex justify-content-end">
            <button type="submit" class="btn btn-primary me-3">Search</button>
            <button type="reset" class="btn btn-secondary">Reset</button>
          </div>
        </form>
      </div>
      <!-- /Account -->
    </div>
    <!--<script src="https://unpkg.com/feather-icons"></script> -->

  <!-- Card Body -->
  <div class="card-body">
    
    <!-- Button Container (Right-Aligned) -->
    <div class="d-flex justify-content-end align-items-center gap-2 mb-3">
      <!-- Choose Column Button -->
      <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#columnModal">
          <i class="bx bx-columns me-1"></i>
          Modify Column
      </button>

      <!-- Print Button -->
      <a href="/export/print" class="btn btn-info btn-sm">
        <i data-feather="printer" class="me-1"></i> Print
      </a>

      <!-- Export Dropdown Button -->
      <div class="dropdown">
        <button class="btn btn-danger btn-sm dropdown-toggle" type="button" id="exportDropdown" data-bs-toggle="dropdown" aria-expanded="false">
          <i data-feather="download" class="me-1"></i> Export
        </button>

        <ul class="dropdown-menu shadow" aria-labelledby="exportDropdown">
          <li><a class="dropdown-item" href="/export/csv"><i data-feather="file-text" class="me-2"></i>Csv</a></li>
          <li><a class="dropdown-item" href="/export/excel"><i data-feather="file" class="me-2"></i>Excel</a></li>
          <li><a class="dropdown-item" href="/export/pdf"><i data-feather="file-minus" class="me-2"></i>Pdf</a></li>
          <li><a class="dropdown-item" href="/export/copy"><i data-feather="copy" class="me-2"></i>Copy</a></li>
        </ul>
      </div>
    </div>

    <!-- Feather Icons Activation -->
    <!--<script>
      feather.replace();
    </script>-->

      <form method="GET" action="{{ url()->current() }}" class="d-flex align-items-center gap-2 mb-3">
            <label for="perPage" class="form-label mb-0">Show</label>
            <select name="perPage" id="perPage" class="form-select w-auto" onchange="this.form.submit()">
                @php
                    $options = [10, 25, 50, 100, 'all'];
                    $selectedPerPage = request('perPage', 10); // default to 10
                @endphp
                @foreach ($options as $option)
                    <option value="{{ $option }}" {{ (string)$selectedPerPage === (string)$option ? 'selected' : '' }}>
                        {{ ucfirst($option) }}
                    </option>
                @endforeach
            </select>
            <span>Entries</span>
        </form>

    <!-- Responsive Table -->
    <!-- Column Toggle Modal -->
<div class="modal fade" id="columnModal" tabindex="-1" aria-labelledby="columnModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="columnModalLabel">Modify Column - List of Endorsement Columns</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          
          <div class="modal-body row">
            <p>Select columns to display:</p>
        <div class="row">
          <!-- LEFT -->
          <div class="col-md-6">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="no" checked disabled>
              <label class="form-check-label">No</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="year" checked>
              <label class="form-check-label">Year</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="division" checked>
              <label class="form-check-label">Division</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="section" checked>
              <label class="form-check-label">Section</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="unit" checked>
              <label class="form-check-label">Unit/Office</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="indicator" checked>
              <label class="form-check-label">Indicator</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="description">
              <label class="form-check-label">Description</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="submission">
              <label class="form-check-label">Submission</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="target" checked>
              <label class="form-check-label">Annual Target</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="metric" checked>
              <label class="form-check-label">Metric</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="category">
              <label class="form-check-label">Category</label>
            </div>
          </div>

          <!-- RIGHT -->
          <div class="col-md-6">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="output">
              <label class="form-check-label">Output/Outcome</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="type" checked>
              <label class="form-check-label">Indicator Type</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="type_def">
              <label class="form-check-label">Indicator Type Definition</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="achievement">
              <label class="form-check-label">Component Achievement</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="status" checked>
              <label class="form-check-label">Status</label>
            </div>
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" data-column="action" checked disabled>
              <label class="form-check-label">Action</label>
            </div>
          </div>
        </div>
      </div>

      <div class="modal-footer justify-content-end">
        <button type="button" class="btn btn-primary btn-sm" onclick="selectAllColumns()">Select All</button>
        <button type="button" class="btn btn-secondary btn-sm" onclick="deselectAllColumns()">Deselect All</button>
        <button type="button" class="btn btn-success btn-sm" onclick="applyColumnSettings()">Apply</button>
      </div>
    </div>
  </div>
</div>

<!-- Table -->
<div class="table-responsive">
             <table id="dataTable" class="table table-bordered align-middle table-hover shadow-sm rounded">
               <thead class="table-light">
  <tr class="text-uppercase text-secondary fw-bold small text-center">
    <th><input type="checkbox" id="checkAll"></th>
    <th class="col-no sortable-header" onclick="sortTable('dataTable', 1, 'number')">
      No <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-year sortable-header" onclick="sortTable('dataTable', 2, 'text')">
      Year <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-division sortable-header" onclick="sortTable('dataTable', 3, 'text')">
      Division <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-section sortable-header" onclick="sortTable('dataTable', 4, 'text')">
      Section <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-unit sortable-header" onclick="sortTable('dataTable', 5, 'text')">
      Unit/Office <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-indicator sortable-header" onclick="sortTable('dataTable', 6, 'text')">
      Indicator <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-description sortable-header" onclick="sortTable('dataTable', 7, 'text')" style="display:none;">
      Description <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-submission sortable-header" onclick="sortTable('dataTable', 8, 'text')" style="display:none;">
      Submission <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-target sortable-header" onclick="sortTable('dataTable', 9, 'number')">
      Annual Target <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-metric sortable-header" onclick="sortTable('dataTable', 10, 'text')">
      Metric <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-category sortable-header" onclick="sortTable('dataTable', 11, 'text')" style="display:none;">
      Category <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-output sortable-header" onclick="sortTable('dataTable', 12, 'text')" style="display:none;">
      Output/Outcome <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-type sortable-header" onclick="sortTable('dataTable', 13, 'text')">
      Indicator Type <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-type_def sortable-header" onclick="sortTable('dataTable', 14, 'text')" style="display:none;">
      Indicator Type Definition <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-achievement sortable-header" onclick="sortTable('dataTable', 15, 'text')" style="display:none;">
      Component Achievement <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-status sortable-header" onclick="sortTable('dataTable', 16, 'text')">
      Status <i class="bi bi-arrow-down-up sort-icon"></i>
    </th>
    <th class="col-action">Action</th>
  </tr>
</thead>
    <tbody>
      <form id="indicatorFormSubmit" method="POST" action="{{ route('indicator-endorse') }}">
        {!! csrf_field() !!}
      @foreach ($submitted_indicator_list as $key => $field)
        <tr>
          <td><input type="checkbox" name="selected[]" value="{{$field->indicator_id.'__1'}}"></td>
          <td class="col-no">{{ $key+1 }}</td>
          <td class="col-year">{{ $field->year }}</td>
          <td class="col-division">{{ formatDivision($field->division) }}</td>
          <td class="col-section">{{ formatDivision($field->section) }}</td>
          <td class="col-unit">{{ formatDivision($field->unit) }}</td>
          <td class="col-indicator">{{ $field->indicator }}</td>
          <td class="col-description" style="display:none">{{ $field->description }}</td>
          <td class="col-submission" style="display:none">{{ formatSubmission($field->submission) }}</td>
          <td class="col-target">{{ $field->annual_target }}</td>
          <td class="col-metric">{{ formatMetric($field->metric) }}</td>
          <td class="col-category" style="display:none">{{ formatCategory($field->category) }}</td>
          <td class="col-output" style="display:none">{{ formatOutputOutcome($field->output_outcome) }}</td>
          <td class="col-type">
            <select id="kpi_indicator_type_id" name="kpi_indicator_type_id[]" class="select2 form-select">
                @foreach ($indicator_type_list as $item)
                  <option value="{{ $field->indicator_id.'__'.$item->kpi_indicator_type_id }}"
                    @if($field->kpi_indicator_type_id == $item->kpi_indicator_type_id) 
                      selected 
                    @endif>
                    {{ $item->indicator_type }}
                  </option>
                @endforeach
            </select>
          </td>
          <td class="col-type_def" style="display:none">{{ $field->indicator_type_def }}</td>
          <td class="col-achievement" style="display:none">{{ formatComponentAchv($field->component_achv) }}</td>
          <td class="col-status"><span class="badge bg-success">{{ ucwords($field->status) }}</span></td>
          <td class="col-action">
            <button type="button" class="btn btn-info btn-sm"
              data-bs-toggle="modal" data-bs-target="#indicatorModal"
              data-indicator_id="{{ $field->indicator_id }}"
              data-year="{{ $field->year }}"
              data-division="{{ $field->division }}"
              data-section="{{ $field->section }}"
              data-unit="{{ $field->unit }}"
              data-indicator="{{ $field->indicator }}"
              data-description="{{ $field->description }}"
              data-annual_target="{{ $field->annual_target }}"
              data-metric="{{ $field->metric }}"
              data-category="{{ $field->category }}"
              data-output_outcome="{{ $field->output_outcome }}"
              data-kpi_indicator_type_id="{{ $field->kpi_indicator_type_id }}"
              data-indicator_type_def="{{ $field->indicator_type_def }}"
              data-component_achievement="{{ $field->component_achv }}"
              data-status="{{ $field->status }}"
              data-kpi_achievement_id="{{ $field->kpi_achievement_id }}"
              data-submission="{{ $field->submission }}">
              <i class="bx bx-show"></i>
            </button>
          </td>
        </tr>
      @endforeach
    </tbody>
  </table>
</div>

<!-- Table Footer with Inline Layout -->
<div class="d-flex justify-content-between align-items-center mt-3 flex-wrap gap-2">
  <div>Showing 1 to 1 of 1 entries</div>
  <nav aria-label="Page navigation">
    <ul class="pagination mb-0">
      <li class="page-item first">
        <a class="page-link" href="javascript:void(0);">
          <i class="tf-icon bx bx-chevrons-left bx-sm"></i>
        </a>
      </li>
      <li class="page-item prev">
        <a class="page-link" href="javascript:void(0);">
          <i class="tf-icon bx bx-chevron-left bx-sm"></i>
        </a>
      </li>
      <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
      <li class="page-item"><a class="page-link" href="javascript:void(0);">2</a></li>
      <li class="page-item next">
        <a class="page-link" href="javascript:void(0);">
          <i class="tf-icon bx bx-chevron-right bx-sm"></i>
        </a>
      </li>
      <li class="page-item last">
        <a class="page-link" href="javascript:void(0);">
          <i class="tf-icon bx bx-chevrons-right bx-sm"></i>
        </a>
      </li>
    </ul>
  </nav>
</div>
<br>
<div class="d-flex justify-content-end gap-2 mt-3">
  <button type="submit" class="btn btn-primary">Endorse</button>
  <button type="button" class="btn btn-danger">Delete</button>
</div>
</form>


    <!-- Account Deactivation Form -->
    <form id="formAccountDeactivation" onsubmit="return false">
      <div class="form-check my-4 ms-2">
        <!-- Optional deactivation checkbox (currently hidden) -->
      </div>
    </form>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="indicatorModal" tabindex="-1" aria-labelledby="indicatorModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="indicatorModalLabel">EDIT INDICATOR</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
     
      <div class="modal-body">
        <form id="indicatorDisable" method="POST" action="{{ route('indicator-disable') }}">
          {!! csrf_field() !!}
          <input type="hidden" id="indicator_id" name="indicator_id_m">
          <input type="hidden" id="kpi_achievement_id" name="kpi_achievement_id_m">
          <div class="mb-3">
            <label class="form-label">Division</label>
            <select class="form-select" name="division_m">
              <option selected>Please Select</option>
              <option value="management">Management Services</option>
              <option value="operations">Operations</option>
              {{-- Added from filter List Start --}}
              <option value="ceo">CEO's Office</option>
              <option value="exports">Export Promotion & Market Access</option>
              <option value="management">Management Services</option>
              <option value="strategic">Strategic Planning</option>
              <option value="transformation">Transformation and Digital Trade Division</option>
              {{-- Added from filter List End --}}
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Section</label>
            <select class="form-select" name="section_m">
              <option selected>Please Select</option>
              <option value="finance">Finance Management</option>
              <option value="hr">HR</option>
              {{-- Add from Search Filter Start --}}
              <option value="asean">ASEAN & Oceania</option>
              <option value="central">Central, West, South Asia & Africa Section</option>
              <option value="china">China & Northeast Asia</option>
              <option value="construction">Construction & Business Services</option>
              <option value="coordination">Coordination & Monitoring</option>
              <option value="corporate">Corporate Management</option>
              <option value="customised">Customised Programme</option>
              <option value="development">Development Assistance</option>
              <option value="digital">Digital Trade</option>
              <option value="electrical">Electrical & Electronics, ICT, Machinery & Equipment</option>
              <option value="europe">Europe & Americas</option>
              <option value="export">Export Academy</option>
              <option value="facility">Facility Management</option>
              <option value="finance">Finance Management</option>
              <option value="halal">Halal, Food & Beverages & Agro-based</option>
              <option value="human">Human Resource</option>
              <option value="information">Information Technology</option>
              <option value="lifestyle">Lifestyle & Life Sciences</option>
              <option value="na">N/A</option>
              <option value="oil">Oil & Gas, Chemical & Energy</option>
              <option value="research">Research</option>
              <option value="strategicCommunication">Strategic Communication</option>
              <option value="strategicDevelopment">Strategic Development</option>
              <option value="transport">Transport & Logistic</option>
              {{-- From Indicator Create Modal - Start --}}
              <option value="ceo">CEO OFFICE</option>
              <option value="exports">EXPORTS PROMOTION & MARKET ACCESS DIVISION</option>
              <option value="management">MANAGEMENT SERVICES DIVISION</option>
              {{-- From Indicator Create Modal - End --}}
              {{-- Add from Search Filter End --}}
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Unit/Office</label>
            <select class="form-select" name="unit_m">
              <option selected>Please Select</option>
              <option value="account">Account</option>
              <option value="procurement">Procurement</option>
              {{-- From Search filter start --}}
              @for ($i = 1; $i <= 87; $i++)
                <option value="unit{{ $i }}">Unit {{ $i }}</option>
              @endfor
              {{-- From Indicator Create Modal - Start --}}
                <option value="ceo">CEO OFFICE</option>
                <option value="exports">EXPORTS PROMOTION & MARKET ACCESS DIVISION</option>
                <option value="management">MANAGEMENT SERVICES DIVISION</option>
              {{-- From Indicator Create Modal - End --}} 
              {{-- From Search filter end --}}
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Year</label>
            <input type="text" class="form-control" name="year_m" value="2025">
          </div>

          <div class="mb-3">
            <label class="form-label">Indicator</label>
            {{-- <input type="text" class="form-control" value="Payment to supplier"> --}}
              <select id="indicator" name="indicator_m" class="select2 form-select">
                <option value="">Please select</option>
                <option value="Programme">Programme</option>
                <option value="Export Sales">Export Sales</option>
                <option value="Companies Assisted">Companies Assisted</option>
              </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Indicator Type</label>
            <select class="form-select" name="kpi_indicator_type_id_m">
              <option selected>Select Indicator Type</option>
              {{-- <option value="Type 1">Type 1</option>
              <option value="Type 2">Type 2</option>
              <option value="Type 3">Type 3</option>
              <option value="Type 4">Type 4</option>
              <option value="Type 5">Type 5</option> --}}
              @foreach ($indicator_type_list as $item)
                <option value="{{ $item->kpi_indicator_type_id }}">
                  {{ formatType($item->indicator_type) }}
                </option>
              @endforeach
            </select>
          </div>

         <div class="mb-3">
  <label class="form-label">Indicator Type Definition</label>
  <div class="form-control bg-light text-dark" style="pointer-events: none;" id="indicator_type_def_m">
    KPI data is manually added in the Achievement Table. Achievement count will be auto calculated
  </div>
</div>

          <div class="mb-3">
            <label class="form-label">Submission</label>
            <select class="form-select" name="submission_m">
              <option value="quarterly" selected>Quarterly</option>
              <option value="monthly">Monthly</option>
              <option value="yearly">Yearly</option>
              {{-- add from add indicator modal start--}}
              <option value="anually">Annually</option>
              <option value="quarter">Quarterly</option>
              <option value="bi_anually">Bi-Annually</option>
              <option value="semi_anually">Semi-Annually</option>
              {{-- add from add indicator modal end--}}
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Annual Target</label>
            <input type="number" class="form-control" name="annual_target_m" value="100">
          </div>

          <div class="mb-3">
            <label class="form-label">Metric</label>
            <input type="text" class="form-control" name="metric_m" value="Percentage">
          </div>

          <div class="mb-3">
            <label class="form-label">Output/Outcome</label>
            <input type="text" class="form-control" name="output_outcome_m" value="Output">
          </div>

          <div class="mb-3">
            <label class="form-label">Status</label>
            <select class="form-select" name="status_m">
              {{-- <option>Draft</option>
              <option selected>Submitted</option>
              <option>Approved</option> --}}
              {{-- from search filter --}}
              <option value="draft">Draft</option>
              <option value="submitted">Submitted</option>
              <option value="endorsed">Endorsed</option>
              <option value="pending">Pending Endorsed</option>
              <option value="proposed">Proposed</option>
              <option value="rejected">Rejected</option>
            </select>
          </div>

          <!-- Radio Section -->
          <div class="mb-3">
            <label class="form-label d-block">Options</label>
            <div class="d-flex flex-wrap gap-3">
              <label class="form-check-label">
                <input type="radio" class="form-check-input" name="activity_name" checked> Activity Name
              </label>
              <label class="form-check-label">
                <input type="radio" class="form-check-input" name="activity_type" checked> Activity Type
              </label>
              <label class="form-check-label">
                <input type="radio" class="form-check-input" name="programme_type" checked> Programme Type
              </label>
            </div>
          </div>
  
      </div>

      <div class="modal-footer d-flex justify-content-end gap-2">
        <button type="button" class="btn btn-primary">Save</button>
        <button type="submit" class="btn btn-danger" onclick="confirmDisable(event)">Disable</button>
      </div>
      </form>
    </div>
  </div>
</div>

{{-- Currently this modal is not using --}}
{{-- <div class="modal fade" id="newIndicatorModal" tabindex="-1" aria-labelledby="newIndicatorModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="newIndicatorForm">
        <div class="modal-header">
          <h5 class="modal-title" id="newIndicatorModalLabel">New Indicator</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <div class="modal-body">
          <div class="mb-3">
            <label for="division" class="form-label">Division</label>
            <input type="text" class="form-control" id="division" name="division">
          </div>

          <div class="mb-3">
            <label for="section" class="form-label">Section</label>
            <input type="text" class="form-control" id="section" name="section">
          </div>

          <div class="mb-3">
            <label for="unit" class="form-label">Unit/Office</label>
            <input type="text" class="form-control" id="unit" name="unit">
          </div>

          <div class="mb-3">
            <label for="indicator" class="form-label">Indicator</label>
            <input type="text" class="form-control" id="indicator" name="indicator">
          </div>

          <div class="mb-3">
            <label for="description" class="form-label">Indicator Description</label>
            <textarea class="form-control" id="description" name="description" rows="3"></textarea>
          </div>

          <div class="mb-3">
            <label for="year" class="form-label">Year</label>
            <input type="number" class="form-control" id="year" name="year" min="2000" max="2100">
          </div>
        </div>

        <div class="mt-2 d-flex gap-1 modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Add Row</button>
          <button type="submit" class="btn btn-primary">Clear Form</button>
          <button type="submit" class="btn btn-primary">Endorse</button>
        </div>
      </form>
    </div>
  </div>
</div> --}}

<!-- JavaScript for Select All functionality -->
{{-- Populate Data to modal Start --}}
<script>
document.addEventListener("DOMContentLoaded", function () {
  var indicatorModal = document.getElementById("indicatorModal");
  if (!indicatorModal) return;

  indicatorModal.addEventListener("show.bs.modal", function (event) {
    var button = event.relatedTarget;
    if (!button) return;

    // Get data attributes
    var indicator_id = button.getAttribute("data-indicator_id");
    var year = button.getAttribute("data-year");
    var division = button.getAttribute("data-division");
    var section = button.getAttribute("data-section");
    var unit = button.getAttribute("data-unit");
    var indicator = button.getAttribute("data-indicator");
    var description = button.getAttribute("data-description");
    var annual_target = button.getAttribute("data-annual_target");
    var metric = button.getAttribute("data-metric");
    var category = button.getAttribute("data-category");
    var output_outcome = button.getAttribute("data-output_outcome");
    var kpi_indicator_type_id = button.getAttribute("data-kpi_indicator_type_id");
    var indicator_type_def = button.getAttribute("data-indicator_type_def");
    var component_achievement = button.getAttribute("data-component_achievement");
    var status = button.getAttribute("data-status");
    var kpi_achievement_id = button.getAttribute("data-kpi_achievement_id");
    var submission = button.getAttribute("data-submission");

    // Set modal fields
    indicatorModal.querySelector('[name="division_m"]').value = division || "";
    indicatorModal.querySelector('[name="section_m"]').value = section || "";
    indicatorModal.querySelector('[name="unit_m"]').value = unit || "";
    indicatorModal.querySelector('[name="year_m"]').value = year || "";
    indicatorModal.querySelector('[name="indicator_m"]').value = indicator || "";
    indicatorModal.querySelector('[name="annual_target_m"]').value = annual_target || "";
    indicatorModal.querySelector('[name="metric_m"]').value = metric || "";
    indicatorModal.querySelector('[name="output_outcome_m"]').value = output_outcome || "";
    indicatorModal.querySelector('[name="submission_m"]').value = submission || "";
    indicatorModal.querySelector('[name="status_m"]').value = status || "";
    indicatorModal.querySelector('[name="kpi_indicator_type_id_m"]').value = kpi_indicator_type_id || "";
    indicatorModal.querySelector('#indicator_type_def_m').innerText = indicator_type_def ?? "";
    indicatorModal.querySelector('[name="indicator_id_m"]').value = indicator_id || "";
    indicatorModal.querySelector('[name="kpi_achievement_id_m"]').value = kpi_achievement_id || "";
  });
});
</script>
{{-- Populate Data to modal End --}}
<script>
  function confirmDisable(event) {
    event.preventDefault();
    if (confirm("Are you sure you want to disable this indicator? This action cannot be undone.")) {
      document.getElementById('indicatorDisable').submit();
    }
  }
</script>
<script>
  document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('input[name="selectedRows[]"]');
    checkboxes.forEach(checkbox => {
      checkbox.checked = this.checked;
    });
  });

   // Track sort direction for each column
  let sortDirections = {};

  function sortTable(tableId, columnIndex, dataType) {
  const table = document.getElementById(tableId);
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const header = table.querySelector(`thead th:nth-child(${columnIndex + 1})`);
  const sortIcon = header.querySelector('.sort-icon');
  
  // Clear other active sort icons
  table.querySelectorAll('.sort-icon').forEach(icon => {
    if (icon !== sortIcon) {
      icon.classList.remove('active');
      icon.className = 'bx bx-sort sort-icon';
    }
  });
  
  // Determine sort direction
  const sortKey = `${tableId}_${columnIndex}`;
  const currentDirection = sortDirections[sortKey] || 'asc';
  const newDirection = currentDirection === 'asc' ? 'desc' : 'asc';
  sortDirections[sortKey] = newDirection;
  
  // Update sort icon
  sortIcon.classList.add('active');
  sortIcon.className = newDirection === 'asc' ? 
    'bx bx-sort-up sort-icon active' : 
    'bx bx-sort-down sort-icon active';
  
  // Sort rows
  rows.sort((a, b) => {
    let aValue = a.cells[columnIndex].textContent.trim();
    let bValue = b.cells[columnIndex].textContent.trim();
    
    if (dataType === 'number') {
      // Convert to numbers, handle non-numeric values
      aValue = parseFloat(aValue.replace(/,/g, '')) || 0;
      bValue = parseFloat(bValue.replace(/,/g, '')) || 0;
      
      if (newDirection === 'asc') {
        return aValue - bValue;
      } else {
        return bValue - aValue;
      }
    } else {
      // Text sorting (alphabetical, case-insensitive)
      aValue = aValue.toLowerCase();
      bValue = bValue.toLowerCase();
      
      if (newDirection === 'asc') {
        return aValue.localeCompare(bValue);
      } else {
        return bValue.localeCompare(aValue);
      }
    }
  });
  
  // Clear tbody and re-append sorted rows
  tbody.innerHTML = '';
  rows.forEach(row => tbody.appendChild(row));
  
  // Add visual feedback
  header.style.backgroundColor = '#e3f2fd';
  setTimeout(() => {
    header.style.backgroundColor = '';
  }, 300);
}
</script>
@endsection

<!-- Column Toggle JavaScript -->
<script>
  function applyColumnSettings() {
    document.querySelectorAll('.column-toggle').forEach(cb => {
      const colClass = `.col-${cb.dataset.column}`;
      document.querySelectorAll(colClass).forEach(el => {
        el.style.display = cb.checked ? '' : 'none';
      });
    });
    const modal = bootstrap.Modal.getInstance(document.getElementById('columnModal'));
    if (modal) modal.hide();
  }

  function selectAllColumns() {
    document.querySelectorAll('.column-toggle').forEach(cb => {
      if (!cb.disabled) cb.checked = true;
    });
  }

  function deselectAllColumns() {
    document.querySelectorAll('.column-toggle').forEach(cb => {
      if (!cb.disabled) cb.checked = false;
    });
  }
</script>