@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Achievement')

@section('content')
<script src="{{ asset('js/kpiAchievement.js') }}"></script>

<!-- SweetAlert2 CDN --> 
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script> 


<!-- Bootstrap Bundle with Popper.js (for modal functionality) --> 
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script> 

<!-- Feather Icons -->
<script src="https://unpkg.com/feather-icons"></script> 

<script>
    feather.replace(); // untuk aktifkan feather icons
</script>

<style>
  .swal2-container {
    z-index: 11000 !important;
  }

  #achievementDetailsPage {
    transition: all 0.4s ease;
  }
  
  .modal-backdrop {
    display: none !important;
  }
  
  body.modal-open {
    overflow: auto !important;
    padding-right: 0 !important;
  }
</style>

<div class="row">
  <div class="nav-align-top mb-6">
    <ul class="nav nav-pills mb-4" role="tablist">
      <li class="nav-item">
        <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
          data-bs-target="#navs-pills-top-profile" aria-controls="navs-pills-top-profile" aria-selected="true">
          <i class="bx bx-list-ul bx-sm me-1_5"></i>LISTING
        </button>
      </li>
      <li class="nav-item">
        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
          data-bs-target="#navs-pills-top-messages" aria-controls="navs-pills-top-messages" aria-selected="false">
          <i class="bx bx-buildings bx-sm me-1_5"></i>COMPANIES BY SECTORS
        </button>
      </li>
      <li class="nav-item">
        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
          data-bs-target="#navs-pills-top-home" aria-controls="navs-pills-top-home" aria-selected="false">
          <i class="bx bx-calendar-event bx-sm me-1_5"></i>ANNUAL PROGRAMME
        </button>
      </li>
    </ul>

    <div class="tab-content">
      <!-- LISTING -->
      <div class="tab-pane fade" id="navs-pills-top-profile" role="tabpanel">
        @include('content.kpi.kpiAchievement-listing')
      </div>

      <!-- COMPANIES BY SECTORS -->
      <div class="tab-pane fade" id="navs-pills-top-messages" role="tabpanel">
        @include('content.kpi.kpiAchievement-companiesBySectors')
      </div>

      <!-- ANNUAL PROGRAMME -->
      <div class="tab-pane fade show active" id="navs-pills-top-home" role="tabpanel">
        @include('content.kpi.kpiAchievement-annualProgramme')
      </div>
    </div>
  </div>
</div>

@endsection
