<button class="btn btn-outline-primary w-100 d-flex justify-content-between align-items-center" id="toggleCommonBtn">
      <span>Common Indicator</span>
      <i class="tf-icon bx bx-chevron-right bx-sm"></i>
    </button>

    <br>
    <!-- Responsive Table -->
    <div id="tableCommon" style="display: none;">

        <form method="GET" action="{{ url()->current() }}" class="d-flex align-items-center gap-2 mb-3">
            <label for="perPage" class="form-label mb-0">Show</label>
            <select name="perPage" id="perPage" class="form-select w-auto" onchange="this.form.submit()">
                @php
                    $options = [10, 25, 50, 100, 'all'];
                    $selectedPerPage = request('perPage', 10); // default to 10
                @endphp
                @foreach ($options as $option)
                    <option value="{{ $option }}" {{ (string)$selectedPerPage === (string)$option ? 'selected' : '' }}>
                        {{ ucfirst($option) }}
                    </option>
                @endforeach
            </select>
            <span>Entries</span>
        </form>

      <div class="table-responsive text-nowrap">
      <table id="indicatorTable" class="table">
        <thead>
          <tr class="text-nowrap">
            <!-- Checkbox untuk "Select All" -->
            <th>
              <input type="checkbox" id="checkAll">
            </th>
            <th>INDICATOR</th>
            <th>METRIC</th>
            <th>TYPE</th>
          </tr>
        </thead>
        <tbody class="table-border-bottom-0">
          <tr>
            <!-- Checkbox untuk row -->
            <td>
              <input type="checkbox" name="selected[]" value="1" class="row-checkbox">
            </td>
            <td>Asset management report for JPAM</td>
            <td>Report</td>
            <td>4</td>
          </tr>
          <!-- Tambah baris lagi ikut data -->
          <tr>
            <!-- Checkbox untuk row -->
            <td>
              <input type="checkbox" name="selected[]" value="2" class="row-checkbox">
            </td>
            <td>Disposal of asset within 4 months from approval for disposal (HQ & TCs)</td>
            <td>Percentage</td>
            <td>1</td>
          </tr>
        </tbody>
      </table>

      </div>

      <!-- Table Footer with Inline Layout -->
      <div class="d-flex justify-content-between align-items-center mt-3 flex-wrap gap-2">
        <!-- Entries Info -->
        <div>Showing 2 to 2 of 2 Entries</div>

      <!-- Pagination -->
      <nav aria-label="Page navigation">
        <ul class="pagination mb-0">
          <li class="page-item first">
            <a class="page-link" href="javascript:void(0);">
              <i class="tf-icon bx bx-chevrons-left bx-sm"></i>
            </a>
          </li>
          <li class="page-item prev">
            <a class="page-link" href="javascript:void(0);">
              <i class="tf-icon bx bx-chevron-left bx-sm"></i>
            </a>
          </li>
          <li class="page-item">
            <a class="page-link" href="javascript:void(0);">1</a>
          </li>
          <li class="page-item">
            <a class="page-link" href="javascript:void(0);">2</a>
          </li>
          <li class="page-item next">
            <a class="page-link" href="javascript:void(0);">
              <i class="tf-icon bx bx-chevron-right bx-sm"></i>
            </a>
          </li>
          <li class="page-item last">
            <a class="page-link" href="javascript:void(0);">
              <i class="tf-icon bx bx-chevrons-right bx-sm"></i>
            </a>
          </li>
        </ul>
      </nav>
  </div>

      <!-- Copy Button -->
      <div class="mt-3">
          <!-- Butang Copy Kedua -->
          <button type="button" class="btn btn-primary" onclick="showCopyConfirm('copyType2')">Copy</button>

      </div>

      <!-- Modal -->
      <div class="modal fade" id="copyConfirmModal" tabindex="-1" aria-labelledby="copyConfirmModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content text-center">
            <div class="modal-header">
              <h5 class="modal-title" id="copyConfirmModalLabel">Confirm Copy</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <!-- Icon di atas -->
              <div class="mb-3">
                <i class="bx bx-error-circle text-warning" style="font-size: 3rem;"></i>
              </div>
              <p class="fs-5 mb-0">Are you sure you want to copy?</p>
            </div>
            <div class="modal-footer justify-content-center border-0">
              <button type="button" class="btn btn-primary" id="confirmCopyBtn">Yes</button>
              <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button> <p></p>
            </div>
          </div>
        </div>
      </div>

      <!-- Success Modal -->
      <div class="modal fade" id="copySuccessModal" tabindex="-1" aria-labelledby="copySuccessModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content text-center">
            <div class="modal-body py-5">
              <div class="mb-3">
                <i class="bx bx-check-circle text-success" style="font-size: 3rem;"></i>
              </div>
              <h5 class="mb-3">Message Copied!</h5>
              <button type="button" class="btn btn-primary" id="successOkBtn">OK</button>
            </div>
          </div>
        </div>
      </div>

      <!-- Error Modal -->
      <div class="modal fade" id="copyErrorModal" tabindex="-1" aria-labelledby="copyErrorModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content text-center">
            <div class="modal-body py-5">
              <div class="mb-3">
                <i class="bx bx-x-circle text-danger" style="font-size: 3rem;"></i>
              </div>
              <h5 class="mb-2 text-danger">Error</h5>
              <p class="mb-3">Indicator <strong>Disposal of Assets and Stocks</strong> already existed!</p>
              <button type="button" class="btn btn-primary" id="errorOkBtn">OK</button>
            </div>
          </div>
        </div>
      </div>
      <br>
</div>